/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine;

import de.esoco.coroutine.CoroutineEnvironment;
import de.esoco.coroutine.CoroutineException;
import de.esoco.coroutine.CoroutineScope;
import de.esoco.lib.concurrent.RunLock;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public class CoroutineContext
extends CoroutineEnvironment {
    private final Executor executor;
    private final AtomicLong runningScopes = new AtomicLong();
    private final RunLock scopeLock = new RunLock();
    private ScheduledExecutorService scheduler;
    private CountDownLatch scopesFinishedSignal = new CountDownLatch(1);

    public CoroutineContext() {
        this(ForkJoinPool.commonPool());
    }

    public CoroutineContext(Executor executor) {
        this.executor = executor;
        if (executor instanceof ScheduledExecutorService) {
            this.scheduler = (ScheduledExecutorService)executor;
        }
    }

    public CoroutineContext(Executor executor, ScheduledExecutorService scheduler) {
        this.executor = executor;
        this.scheduler = scheduler;
    }

    public void awaitAllScopes() {
        if (this.scopesFinishedSignal != null) {
            try {
                this.scopesFinishedSignal.await();
            }
            catch (InterruptedException e) {
                throw new CoroutineException(e);
            }
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = Executors.newScheduledThreadPool(1);
        }
        return this.scheduler;
    }

    public long getScopeCount() {
        return this.runningScopes.get();
    }

    void scopeFinished(CoroutineScope scope) {
        if (this.runningScopes.decrementAndGet() == 0L) {
            this.scopeLock.runLocked(() -> this.scopesFinishedSignal.countDown());
        }
    }

    void scopeLaunched(CoroutineScope scope) {
        if (this.runningScopes.incrementAndGet() == 1L) {
            this.scopeLock.runLocked(() -> {
                if (this.scopesFinishedSignal.getCount() == 0L) {
                    this.scopesFinishedSignal = new CountDownLatch(1);
                }
            });
        }
    }
}

