/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine;

import de.esoco.coroutine.Channel;
import de.esoco.coroutine.ChannelId;
import de.esoco.lib.concurrent.RunLock;
import java.util.HashMap;
import java.util.Map;
import org.obrel.core.RelatedObject;

public abstract class CoroutineEnvironment
extends RelatedObject {
    private final Map<ChannelId<?>, Channel<?>> channels = new HashMap();
    private final RunLock channelLock = new RunLock();

    public <T> Channel<T> createChannel(ChannelId<T> id, int capacity) {
        return (Channel)this.channelLock.supplyLocked(() -> {
            if (this.channels.containsKey(id)) {
                throw new IllegalArgumentException(String.format("Channel %s already exists", id));
            }
            Channel aChannel = new Channel(id, capacity);
            this.channels.put(id, aChannel);
            return aChannel;
        });
    }

    public <T> Channel<T> getChannel(ChannelId<T> id) {
        return (Channel)this.channelLock.supplyLocked(() -> {
            Channel<Object> rChannel = this.channels.get(id);
            if (rChannel == null) {
                rChannel = this.createChannel(id, 1);
            }
            return rChannel;
        });
    }

    public boolean hasChannel(ChannelId<?> id) {
        return (Boolean)this.channelLock.supplyLocked(() -> this.channels.containsKey(id));
    }

    public void removeChannel(ChannelId<?> id) {
        this.channelLock.runLocked(() -> this.channels.remove(id));
    }
}

