/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine;

import de.esoco.coroutine.Channel;
import de.esoco.coroutine.ChannelId;
import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineContext;
import de.esoco.coroutine.CoroutineEnvironment;
import de.esoco.coroutine.CoroutineException;
import de.esoco.coroutine.CoroutineScopeException;
import de.esoco.coroutine.Coroutines;
import de.esoco.coroutine.Suspension;
import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.concurrent.RunLock;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.obrel.core.Relatable;

public class CoroutineScope
extends CoroutineEnvironment {
    private final CoroutineContext context;
    private final AtomicLong runningCoroutines = new AtomicLong();
    private final RunLock scopeLock = new RunLock();
    private final Collection<Suspension<?>> suspensions = new LinkedHashSet();
    private final Collection<Continuation<?>> failedContinuations = new LinkedHashSet();
    private CountDownLatch finishSignal = new CountDownLatch(1);
    private boolean cancelOnError = true;
    private boolean cancelled = false;

    CoroutineScope(CoroutineContext context) {
        this.context = context != null ? context : Coroutines.getDefaultContext();
        this.context.scopeLaunched(this);
    }

    public static void launch(CoroutineContext context, ScopeCode code) {
        CoroutineScope aScope = new CoroutineScope(context);
        try {
            code.runIn(aScope);
            aScope.await();
        }
        catch (Exception e) {
            aScope.await();
            throw new CoroutineScopeException(e, aScope.failedContinuations);
        }
        aScope.checkThrowErrors();
    }

    public static void launch(ScopeCode code) {
        CoroutineScope.launch(null, code);
    }

    public static <T> ScopeFuture<T> produce(CoroutineContext context, Function<? super CoroutineScope, T> getResult, ScopeCode code) {
        return new ScopeFuture<T>(new CoroutineScope(context), getResult, code);
    }

    public static <T> ScopeFuture<T> produce(Function<? super CoroutineScope, T> getResult, ScopeCode code) {
        return CoroutineScope.produce(null, getResult, code);
    }

    public void await() {
        try {
            if (this.getCoroutineCount() > 0L) {
                this.finishSignal.await();
            }
        }
        catch (Exception e) {
            throw new CoroutineException(e);
        }
        finally {
            this.context.scopeFinished(this);
            Coroutines.closeManagedResources((Relatable)this, (Consumer)this.get(Coroutines.EXCEPTION_HANDLER));
        }
    }

    public boolean await(long timeout, TimeUnit unit) {
        boolean completed;
        try {
            completed = this.finishSignal.await(timeout, unit);
        }
        catch (Exception e) {
            throw new CoroutineException(e);
        }
        finally {
            this.context.scopeFinished(this);
            Coroutines.closeManagedResources((Relatable)this, (Consumer)this.get(Coroutines.EXCEPTION_HANDLER));
        }
        return completed;
    }

    public void cancel() {
        this.scopeLock.runLocked(() -> {
            if (!this.isFinished()) {
                this.cancelled = true;
                for (Suspension<?> rSuspension : this.suspensions) {
                    rSuspension.cancel();
                }
                this.suspensions.clear();
            }
        });
    }

    public CoroutineContext context() {
        return this.context;
    }

    @Override
    public <T> Channel<T> getChannel(ChannelId<T> id) {
        if (this.context.hasChannel(id)) {
            return this.context.getChannel(id);
        }
        return super.getChannel(id);
    }

    public long getCoroutineCount() {
        return this.runningCoroutines.get();
    }

    @Override
    public boolean hasChannel(ChannelId<?> id) {
        return super.hasChannel(id) || this.context.hasChannel(id);
    }

    public boolean isCancelOnError() {
        return this.cancelOnError;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isFinished() {
        return this.finishSignal.getCount() == 0L;
    }

    @Override
    public void removeChannel(ChannelId<?> id) {
        if (this.hasChannel(id)) {
            super.removeChannel(id);
        } else {
            this.context.removeChannel(id);
        }
    }

    public void setCancelOnError(boolean cancelOnError) {
        this.cancelOnError = cancelOnError;
    }

    public String toString() {
        return String.format("%s[%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.runningCoroutines.longValue());
    }

    void addSuspension(Suspension<?> suspension) {
        this.scopeLock.runLocked(() -> {
            if (this.cancelled) {
                suspension.cancel();
            } else {
                this.suspensions.add(suspension);
            }
        });
    }

    void checkThrowErrors() {
        if (this.failedContinuations.size() > 0) {
            if (this.failedContinuations.size() == 1) {
                Throwable eError = ((Continuation)CollectionUtil.firstElementOf(this.failedContinuations)).getError();
                if (eError instanceof CoroutineException) {
                    throw (CoroutineException)eError;
                }
                throw new CoroutineScopeException(this.failedContinuations);
            }
            throw new CoroutineScopeException(this.failedContinuations);
        }
    }

    void continuationErrorHandled(Continuation<?> continuation) {
        this.failedContinuations.remove(continuation);
    }

    void coroutineFinished(Continuation<?> continuation) {
        if (this.runningCoroutines.decrementAndGet() == 0L) {
            this.finishSignal.countDown();
        }
    }

    void coroutineStarted(Continuation<?> continuation) {
        if (this.runningCoroutines.incrementAndGet() == 1L && this.finishSignal.getCount() == 0L) {
            this.finishSignal = new CountDownLatch(1);
        }
    }

    void fail(Continuation<?> continuation) {
        this.scopeLock.runLocked(() -> {
            this.failedContinuations.add(continuation);
            if (this.cancelOnError && !this.cancelled) {
                this.cancel();
            }
            this.coroutineFinished(continuation);
        });
    }

    void removeSuspension(Suspension<?> suspension) {
        this.scopeLock.runLocked(() -> {
            if (!this.cancelled) {
                this.suspensions.remove(suspension);
            }
        });
    }

    public static class ScopeFuture<T>
    implements Future<T> {
        private final CoroutineScope scope;
        private final Function<? super CoroutineScope, T> getResult;
        private Exception scopeCodeError;

        public ScopeFuture(CoroutineScope scope, Function<? super CoroutineScope, T> getResult, ScopeCode code) {
            this.scope = scope;
            this.getResult = getResult;
            try {
                code.runIn(scope);
            }
            catch (Exception e) {
                this.scopeCodeError = e;
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean terminated;
            boolean bl = terminated = this.scope.isFinished() || this.scope.isCancelled();
            if (!terminated) {
                this.scope.cancel();
                terminated = true;
            }
            return terminated;
        }

        @Override
        public T get() {
            this.scope.await();
            return this.getImpl();
        }

        @Override
        public T get(long timeout, TimeUnit unit) {
            this.scope.await(timeout, unit);
            return this.getImpl();
        }

        @Override
        public boolean isCancelled() {
            return this.scope.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.scope.isFinished();
        }

        private T getImpl() {
            if (this.scopeCodeError != null) {
                throw new CoroutineScopeException(this.scopeCodeError, this.scope.failedContinuations);
            }
            this.scope.checkThrowErrors();
            if (this.isCancelled()) {
                throw new CancellationException("Scope is cancelled");
            }
            return this.getResult != null ? (T)this.getResult.apply(this.scope) : null;
        }
    }

    @FunctionalInterface
    public static interface ScopeCode {
        public void runIn(CoroutineScope var1) throws Exception;
    }
}

