/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineContext;
import de.esoco.coroutine.CoroutineEvent;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.Suspension;
import de.esoco.lib.event.EventDispatcher;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.type.MetaTypes;

public class Coroutines {
    public static final RelationType<Consumer<Throwable>> EXCEPTION_HANDLER = RelationTypes.newDefaultValueType(t -> t.printStackTrace(), (RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<EventDispatcher<CoroutineEvent>> COROUTINE_LISTENERS = RelationTypes.newInitialValueType(r -> new EventDispatcher(), (RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<BiConsumer<Suspension<?>, Boolean>> COROUTINE_SUSPENSION_LISTENER = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<BiConsumer<CoroutineStep<?, ?>, Continuation<?>>> COROUTINE_STEP_LISTENER = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private static CoroutineContext defaultContext = new CoroutineContext();

    private Coroutines() {
    }

    public static void closeManagedResources(Relatable state, Consumer<Throwable> errorHandler) {
        state.streamRelations().filter(r -> r.hasAnnotation(MetaTypes.MANAGED) && r.getTarget() != null).map(Relation::getTarget).forEach(t -> {
            if (t instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)t).close();
                }
                catch (Exception e) {
                    errorHandler.accept(e);
                }
            }
        });
    }

    public static CoroutineContext getDefaultContext() {
        return defaultContext;
    }

    public static void setDefaultContext(CoroutineContext context) {
        Objects.requireNonNull(context);
        defaultContext = context;
    }

    static {
        RelationTypes.init((Class[])new Class[]{Coroutines.class});
    }
}

