/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.Suspension;
import de.esoco.lib.concurrent.RunLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Selection<T, V, R>
extends Suspension<T> {
    private final CoroutineStep<R, ?> resumeSelectionStep;
    private final Predicate<Continuation<?>> checkSelect;
    private final Predicate<Continuation<?>> checkComplete;
    private final boolean singleValue;
    private final List<V> results = new ArrayList<V>();
    private final List<Continuation<? extends V>> continuations = new ArrayList<Continuation<? extends V>>();
    private final RunLock stateLock = new RunLock();
    private boolean sealed = false;
    private boolean finished = false;
    private Runnable finishAction = this::resume;

    private Selection(CoroutineStep<?, T> suspendingStep, CoroutineStep<R, ?> resumeStep, Continuation<?> continuation, Predicate<Continuation<?>> checkComplete, Predicate<Continuation<?>> checkSelect, boolean singleValue) {
        super(suspendingStep, null, continuation);
        this.resumeSelectionStep = resumeStep;
        this.checkSelect = checkSelect;
        this.checkComplete = checkComplete;
        this.singleValue = singleValue;
    }

    public static <T, V> Selection<T, V, Collection<V>> ofMultipleValues(CoroutineStep<?, T> suspendingStep, CoroutineStep<Collection<V>, ?> resumeStep, Continuation<?> rContinuation, Predicate<Continuation<?>> checkComplete, Predicate<Continuation<?>> checkSelect) {
        Selection<T, V, Collection<V>> aSelection = new Selection<T, V, Collection<V>>(suspendingStep, resumeStep, rContinuation, checkComplete, checkSelect, false);
        return aSelection;
    }

    public static <T> Selection<T, T, T> ofSingleValue(CoroutineStep<?, T> suspendingStep, CoroutineStep<T, ?> resumeStep, Continuation<?> continuation, Predicate<Continuation<?>> checkSelect) {
        return new Selection(suspendingStep, resumeStep, continuation, c -> true, checkSelect, true);
    }

    public void add(Continuation<? extends V> continuation) {
        this.stateLock.runLocked(() -> {
            if (this.sealed) {
                throw new IllegalStateException("Selection is sealed");
            }
            this.continuations.add(continuation);
        });
        continuation.onFinish(this::continuationFinished).onCancel(this::continuationCancelled).onError(this::continuationFailed);
        if (this.finished) {
            continuation.cancel();
        }
    }

    @Override
    public void cancel() {
        this.stateLock.runLocked(() -> {
            this.finished = true;
            this.finishAction = this::cancel;
            this.checkComplete();
        });
    }

    public void seal() {
        this.stateLock.runLocked(() -> {
            this.sealed = true;
            this.checkComplete();
        });
    }

    @Override
    public String toString() {
        return String.format("%s[%s -> %s]", new Object[]{this.getClass().getSimpleName(), this.suspendingStep(), this.resumeSelectionStep});
    }

    void continuationCancelled(Continuation<? extends V> continuation) {
        this.stateLock.runLocked(() -> {
            this.continuations.remove(continuation);
            this.checkComplete();
        });
    }

    void continuationFailed(Continuation<? extends V> continuation) {
        this.stateLock.runLocked(() -> {
            this.continuations.remove(continuation);
            this.finished = true;
            this.finishAction = () -> this.fail(continuation.getError());
            this.checkComplete();
        });
    }

    void continuationFinished(Continuation<? extends V> continuation) {
        this.stateLock.runLocked(() -> {
            this.continuations.remove(continuation);
            if (!this.finished) {
                if (this.checkSelect.test(continuation)) {
                    this.results.add(continuation.getResult());
                }
                this.finished = this.checkComplete.test(continuation);
            }
            this.checkComplete();
        });
    }

    @Override
    void resumeAsync() {
        List<V> result = this.singleValue ? (this.results.size() >= 1 ? this.results.get(0) : null) : this.results;
        this.continuation().resumeAsync(this.resumeSelectionStep, result);
    }

    private void checkComplete() {
        if (this.finished && !this.continuations.isEmpty()) {
            new ArrayList<Continuation<V>>(this.continuations).forEach((Consumer<Continuation<V>>)((Consumer<Continuation>)Continuation::cancel));
        }
        if (this.sealed && this.continuations.isEmpty()) {
            this.finished = true;
            this.finishAction.run();
        }
    }
}

