/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.Coroutine;
import de.esoco.coroutine.CoroutineStep;
import java.util.concurrent.CompletableFuture;

public class Subroutine<I, T, O>
extends Coroutine<I, O> {
    public Subroutine(Coroutine<I, T> coroutine, CoroutineStep<T, O> returnStep) {
        this.init(coroutine.getCode().withLastStep(new SubroutineReturn<T, O>(returnStep)), null);
    }

    public void runAsync(CompletableFuture<I> execution, Continuation<?> continuation) {
        continuation.subroutineStarted(this);
        this.getCode().runAsync(execution, null, continuation);
    }

    public O runBlocking(I input, Continuation<?> continuation) {
        continuation.subroutineStarted(this);
        return this.getCode().runBlocking(input, continuation);
    }

    static class SubroutineReturn<I, O>
    extends CoroutineStep<I, O> {
        private final CoroutineStep<I, O> returnStep;

        public SubroutineReturn(CoroutineStep<I, O> returnStep) {
            this.returnStep = returnStep;
        }

        @Override
        public void runAsync(CompletableFuture<I> previousExecution, CoroutineStep<O, ?> nextStep, Continuation<?> continuation) {
            continuation.subroutineFinished();
            this.returnStep.runAsync(previousExecution, nextStep, continuation);
        }

        @Override
        protected O execute(I input, Continuation<?> continuation) {
            continuation.subroutineFinished();
            return this.returnStep.execute(input, continuation);
        }
    }
}

