/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.lib.concurrent.RunLock;
import de.esoco.lib.expression.monad.Option;

public class Suspension<T> {
    private final CoroutineStep<?, T> suspendingStep;
    private final CoroutineStep<T, ?> resumeStep;
    private final Continuation<?> continuation;
    private final RunLock cancelLock = new RunLock();
    private T value;
    private boolean cancelled = false;
    private Option<Runnable> cancelHandler = Option.none();

    protected Suspension(CoroutineStep<?, T> suspendingStep, CoroutineStep<T, ?> resumeStep, Continuation<?> continuation) {
        this.suspendingStep = suspendingStep;
        this.resumeStep = resumeStep;
        this.continuation = continuation;
    }

    public void cancel() {
        this.cancelLock.runLocked(() -> {
            if (!this.cancelled) {
                this.cancelHandler.ifExists(Runnable::run);
            }
            this.cancelled = true;
        });
        if (!this.continuation.isFinished()) {
            this.continuation.cancel();
        }
    }

    public final Continuation<?> continuation() {
        return this.continuation;
    }

    public void fail(Throwable error) {
        this.cancelLock.runLocked(() -> {
            this.cancelled = true;
        });
        if (!this.continuation.isCancelled()) {
            this.continuation.fail(error);
        }
    }

    public void ifNotCancelled(Runnable code) {
        this.cancelLock.runLocked(() -> {
            if (!this.cancelled) {
                code.run();
            }
        });
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    public void onCancel(Option<Runnable> cancelHandler) {
        this.cancelHandler = cancelHandler;
    }

    public final void resume() {
        this.resume(this.value);
    }

    public void resume(T value) {
        if (!this.cancelled) {
            this.value = value;
            this.continuation.suspensionResumed(this);
            this.resumeAsync();
        }
    }

    public final CoroutineStep<?, T> suspendingStep() {
        return this.suspendingStep;
    }

    public String toString() {
        return String.format("%s[%s -> %s]", new Object[]{this.getClass().getSimpleName(), this.suspendingStep, this.resumeStep});
    }

    public final T value() {
        return this.value;
    }

    public Suspension<T> withValue(T value) {
        this.value = value;
        return this;
    }

    void resumeAsync() {
        this.continuation.resumeAsync(this.resumeStep, this.value);
    }
}

