/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step;

import de.esoco.coroutine.Channel;
import de.esoco.coroutine.ChannelId;
import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineException;
import de.esoco.coroutine.CoroutineStep;
import java.util.Objects;
import java.util.function.Function;

public abstract class ChannelStep<I, O>
extends CoroutineStep<I, O> {
    private final Function<Continuation<?>, ChannelId<O>> fGetChannelId;

    public ChannelStep(Function<Continuation<?>, ChannelId<O>> fGetChannelId) {
        Objects.requireNonNull(fGetChannelId);
        this.fGetChannelId = fGetChannelId;
    }

    public Channel<O> getChannel(Continuation<?> rContinuation) {
        ChannelId<O> rId = this.fGetChannelId.apply(rContinuation);
        if (rId == null) {
            throw new CoroutineException("No channel ID returned by %s", this.fGetChannelId);
        }
        return rContinuation.getChannel(rId);
    }
}

