/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.lib.expression.Functions;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.obrel.core.RelationType;

public class CodeExecution<I, O>
extends CoroutineStep<I, O> {
    private final BiFunction<I, Continuation<?>, O> code;

    public CodeExecution(BiFunction<I, Continuation<?>, O> code) {
        Objects.requireNonNull(code);
        this.code = code;
    }

    public CodeExecution(Function<I, O> code) {
        Objects.requireNonNull(code);
        this.code = (i, c) -> code.apply(i);
    }

    public static <I, O> CodeExecution<I, O> apply(Function<I, O> code) {
        return new CodeExecution<I, O>(code);
    }

    public static <I, O> CodeExecution<I, O> apply(BiFunction<I, Continuation<?>, O> code) {
        return new CodeExecution<I, O>(code);
    }

    public static <T> CodeExecution<T, T> consume(Consumer<T> code) {
        return new CodeExecution(Functions.asFunction(code));
    }

    public static <T> CodeExecution<T, T> consume(BiConsumer<T, Continuation<?>> code) {
        return new CodeExecution(Functions.asFunction(code));
    }

    public static <I, O> CodeExecution<I, O> getParameter(RelationType<O> rSource) {
        return CodeExecution.supply((Continuation<?> c) -> c.get(rSource));
    }

    public static <I, O> CodeExecution<I, O> getScopeParameter(RelationType<O> rSource) {
        return CodeExecution.supply((Continuation<?> c) -> c.scope().get(rSource));
    }

    public static <I, O> CodeExecution<I, O> map(Function<I, O> mapper) {
        return new CodeExecution<I, O>(mapper);
    }

    public static <T> CodeExecution<T, Void> run(Runnable code) {
        return new CodeExecution(Functions.asFunction((Runnable)code));
    }

    public static <T> CodeExecution<T, T> run(Consumer<Continuation<?>> code) {
        return new CodeExecution<Object, Object>((v, c) -> {
            code.accept((Continuation<?>)c);
            return v;
        });
    }

    public static <T> CodeExecution<T, T> setParameter(RelationType<T> rTarget) {
        return CodeExecution.apply((I v, Continuation<?> c) -> {
            c.set(rTarget, v);
            return v;
        });
    }

    public static <T> CodeExecution<T, T> setScopeParameter(RelationType<T> rTarget) {
        return CodeExecution.apply((I v, Continuation<?> c) -> {
            c.scope().set(rTarget, v);
            return v;
        });
    }

    public static <I, O> CodeExecution<I, O> supply(Supplier<O> code) {
        return new CodeExecution<I, O>(Functions.asFunction(code));
    }

    public static <I, O> CodeExecution<I, O> supply(Function<Continuation<?>, O> code) {
        return new CodeExecution<Object, Object>((v, c) -> code.apply((Continuation<?>)c));
    }

    @Override
    protected O execute(I input, Continuation<?> continuation) {
        return this.code.apply(input, continuation);
    }
}

