/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.Coroutine;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Collect<I, O>
extends CoroutineStep<I, Collection<O>> {
    private final List<Coroutine<? super I, ? extends O>> aCoroutines = new ArrayList<Coroutine<? super I, ? extends O>>();
    private Predicate<Continuation<?>> pCollectCritiera = c -> true;
    private Predicate<Continuation<?>> pCompletionCritiera = c -> false;

    public Collect(Collection<Coroutine<? super I, ? extends O>> rFromCoroutines) {
        if (rFromCoroutines.size() == 0) {
            throw new IllegalArgumentException("At least one coroutine to collect is required");
        }
        this.aCoroutines.addAll(rFromCoroutines);
    }

    private Collect(Collect<I, O> rOther) {
        this.aCoroutines.addAll(rOther.aCoroutines);
        this.pCollectCritiera = rOther.pCollectCritiera;
        this.pCompletionCritiera = rOther.pCompletionCritiera;
    }

    @SafeVarargs
    public static <I, O> Collect<I, O> collect(Coroutine<? super I, ? extends O> ... rFromCoroutines) {
        return new Collect<I, O>(Arrays.asList(rFromCoroutines));
    }

    @SafeVarargs
    public static <I, O> Collect<I, O> collect(CoroutineStep<? super I, ? extends O> ... rFromSteps) {
        return new Collect<I, O>(Arrays.asList(rFromSteps).stream().map(rStep -> new Coroutine(rStep)).collect(Collectors.toList()));
    }

    public Collect<I, O> and(Coroutine<? super I, ? extends O> rCoroutine) {
        Collect<I, O> aCollect = new Collect<I, O>(this);
        aCollect.aCoroutines.add(rCoroutine);
        return aCollect;
    }

    public Collect<I, O> and(CoroutineStep<? super I, ? extends O> rStep) {
        Collect<I, O> aCollect = new Collect<I, O>(this);
        aCollect.aCoroutines.add(new Coroutine<I, O>(rStep));
        return aCollect;
    }

    @Override
    public void runAsync(CompletableFuture<I> previousExecution, CoroutineStep<Collection<O>, ?> nextStep, Continuation<?> continuation) {
        continuation.continueAccept(previousExecution, rInput -> this.collectAsync(rInput, nextStep, continuation));
    }

    public Collect<I, O> until(Predicate<Continuation<?>> pCompletionCriteria) {
        Collect<? super I, ? extends O> aCollect = new Collect<I, O>(this.aCoroutines);
        aCollect.pCompletionCritiera = pCompletionCriteria;
        return aCollect;
    }

    public Collect<I, O> when(Predicate<Continuation<?>> pCollectCriteria) {
        Collect<? super I, ? extends O> aCollect = new Collect<I, O>(this.aCoroutines);
        aCollect.pCollectCritiera = pCollectCriteria;
        return aCollect;
    }

    @Override
    protected Collection<O> execute(I input, Continuation<?> continuation) {
        return (Collection)new Coroutine(this).runAsync(continuation.scope(), input).getResult();
    }

    void collectAsync(I rInput, CoroutineStep<Collection<O>, ?> rNextStep, Continuation<?> rContinuation) {
        Selection aSelection = Selection.ofMultipleValues(this, rNextStep, rContinuation, this.pCompletionCritiera, this.pCollectCritiera);
        rContinuation.suspendTo(aSelection);
        this.aCoroutines.forEach(rCoroutine -> aSelection.add(rCoroutine.runAsync(rContinuation.scope(), rInput)));
        aSelection.seal();
    }
}

