/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineStep;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class Condition<I, O>
extends CoroutineStep<I, O> {
    private final BiPredicate<? super I, Continuation<?>> pCondition;
    private final CoroutineStep<I, O> rRunIfTrue;
    private final CoroutineStep<I, O> rRunIfFalse;

    public Condition(BiPredicate<? super I, Continuation<?>> pCondition, CoroutineStep<I, O> rRunIfTrue, CoroutineStep<I, O> rRunIfFalse) {
        Objects.requireNonNull(pCondition);
        Objects.requireNonNull(rRunIfTrue);
        this.pCondition = pCondition;
        this.rRunIfTrue = rRunIfTrue;
        this.rRunIfFalse = rRunIfFalse;
    }

    public static <I, O> Condition<I, O> doIf(Predicate<? super I> fCondition, CoroutineStep<I, O> rRunIfTrue) {
        return new Condition<Object, O>((i, c) -> fCondition.test((Object)i), rRunIfTrue, null);
    }

    public static <I, O> Condition<I, O> doIf(BiPredicate<? super I, Continuation<?>> fCondition, CoroutineStep<I, O> rRunIfTrue) {
        return new Condition<I, O>(fCondition, rRunIfTrue, null);
    }

    public static <I, O> Condition<I, O> doIfElse(BiPredicate<? super I, Continuation<?>> fCondition, CoroutineStep<I, O> rRunIfTrue, CoroutineStep<I, O> rRunIfFalse) {
        return new Condition<I, O>(fCondition, rRunIfTrue, rRunIfFalse);
    }

    public static <I, O> Condition<I, O> doIfElse(Predicate<? super I> fCondition, CoroutineStep<I, O> rRunIfTrue, CoroutineStep<I, O> rRunIfFalse) {
        return new Condition<Object, O>((i, c) -> fCondition.test((Object)i), rRunIfTrue, rRunIfFalse);
    }

    public Condition<I, O> orElse(CoroutineStep<I, O> rRunIfFalse) {
        return new Condition<I, O>(this.pCondition, this.rRunIfTrue, rRunIfFalse);
    }

    @Override
    public void runAsync(CompletableFuture<I> previousExecution, CoroutineStep<O, ?> nextStep, Continuation<?> continuation) {
        continuation.continueAccept(previousExecution, i -> {
            CoroutineStep<I, O> rStep;
            CoroutineStep<I, O> coroutineStep = rStep = this.pCondition.test(i, continuation) ? this.rRunIfTrue : this.rRunIfFalse;
            if (rStep != null) {
                rStep.runAsync(previousExecution, nextStep, continuation);
            } else {
                this.terminateCoroutine(continuation);
            }
        });
    }

    @Override
    protected O execute(I input, Continuation<?> continuation) {
        O rResult = null;
        if (this.pCondition.test(input, continuation)) {
            rResult = this.rRunIfTrue.runBlocking(input, continuation);
        } else if (this.rRunIfFalse != null) {
            rResult = this.rRunIfFalse.runBlocking(input, continuation);
        }
        return rResult;
    }
}

