/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineException;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.Suspension;
import de.esoco.lib.datatype.Pair;
import de.esoco.lib.expression.monad.Option;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class Delay<T>
extends CoroutineStep<T, T> {
    private final Function<Continuation<?>, Pair<Long, TimeUnit>> getDuration;

    public Delay(Function<Continuation<?>, Pair<Long, TimeUnit>> getDuration) {
        Objects.requireNonNull(getDuration);
        this.getDuration = getDuration;
    }

    public static <T> Delay<T> sleep(Function<Continuation<?>, Pair<Long, TimeUnit>> getDuration) {
        return new Delay<T>(getDuration);
    }

    public static <T> Delay<T> sleep(long milliseconds) {
        return Delay.sleep(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static <T> Delay<T> sleep(long duration, TimeUnit timeUnit) {
        return new Delay<T>(c -> Pair.of((Object)duration, (Object)((Object)timeUnit)));
    }

    @Override
    public T execute(T input, Continuation<?> continuation) {
        try {
            Pair<Long, TimeUnit> duration = this.getDuration.apply(continuation);
            ((TimeUnit)((Object)duration.second())).sleep((Long)duration.first());
        }
        catch (Exception e) {
            throw new CoroutineException(e);
        }
        return input;
    }

    @Override
    public void runAsync(CompletableFuture<T> previousExecution, CoroutineStep<T, ?> nextStep, Continuation<?> continuation) {
        continuation.continueAccept(previousExecution, v -> {
            Suspension suspension = continuation.suspend(this, nextStep);
            Pair<Long, TimeUnit> duration = this.getDuration.apply(continuation);
            ScheduledFuture<?> delayedExecution = continuation.context().getScheduler().schedule(() -> suspension.resume(v), (long)((Long)duration.first()), (TimeUnit)((Object)((Object)duration.second())));
            suspension.onCancel((Option<Runnable>)Option.of(() -> delayedExecution.cancel(true)));
        });
    }
}

