/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.step.CodeExecution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class Iteration<T, R, I extends Iterable<T>, C extends Collection<R>>
extends CoroutineStep<I, C> {
    private final CoroutineStep<T, R> rProcessingStep;
    private final Supplier<C> fCollectionFactory;

    public Iteration(Supplier<C> fCollectionFactory, CoroutineStep<T, R> rProcessingStep) {
        this.rProcessingStep = rProcessingStep;
        this.fCollectionFactory = fCollectionFactory;
    }

    public static <T, R, I extends Iterable<T>> CoroutineStep<I, List<R>> collectEach(CoroutineStep<T, R> rProcessingStep) {
        return Iteration.collectEachInto(() -> new ArrayList(), rProcessingStep);
    }

    public static <T, R, I extends Iterable<T>, C extends Collection<R>> CoroutineStep<I, C> collectEachInto(Supplier<C> fCollectionFactory, CoroutineStep<T, R> rProcessingStep) {
        return new Iteration<T, R, I, C>(fCollectionFactory, rProcessingStep);
    }

    public static <T, I extends Iterable<T>> CoroutineStep<I, Void> forEach(CoroutineStep<T, ?> rProcessingStep) {
        return new Iteration(null, rProcessingStep);
    }

    @Override
    public void runAsync(CompletableFuture<I> previousExecution, CoroutineStep<C, ?> nextStep, Continuation<?> continuation) {
        Collection aResults = this.fCollectionFactory != null ? (Collection)this.fCollectionFactory.get() : null;
        continuation.continueAccept(previousExecution, i -> this.iterateAsync(i.iterator(), aResults, nextStep, continuation));
    }

    @Override
    protected C execute(I input, Continuation<?> continuation) {
        Collection aResults = this.fCollectionFactory != null ? (Collection)this.fCollectionFactory.get() : null;
        for (Object rValue : input) {
            R aResult = this.rProcessingStep.runBlocking(rValue, continuation);
            if (aResults == null) continue;
            aResults.add(aResult);
        }
        return (C)aResults;
    }

    private void iterateAsync(Iterator<T> rIterator, C rResults, CoroutineStep<C, ?> rNextStep, Continuation<?> rContinuation) {
        if (rIterator.hasNext()) {
            CompletableFuture<Object> fNextIteration = CompletableFuture.supplyAsync(() -> rIterator.next(), rContinuation);
            this.rProcessingStep.runAsync(fNextIteration, CodeExecution.consume(o -> {
                if (rResults != null) {
                    rResults.add(o);
                }
                this.iterateAsync(rIterator, rResults, rNextStep, rContinuation);
            }), rContinuation);
        } else {
            rContinuation.suspend(this, rNextStep).resume(rResults);
        }
    }
}

