/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.step.CodeExecution;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class Loop<T>
extends CoroutineStep<T, T> {
    private final BiPredicate<? super T, Continuation<?>> pCondition;
    private final CoroutineStep<T, T> rLoopedStep;

    public Loop(BiPredicate<? super T, Continuation<?>> fCondition, CoroutineStep<T, T> rLoopedStep) {
        this.pCondition = fCondition;
        this.rLoopedStep = rLoopedStep;
    }

    public static <T> Loop<T> loopWhile(BiPredicate<? super T, Continuation<?>> pCondition, CoroutineStep<T, T> rLoopedStep) {
        return new Loop<T>(pCondition, rLoopedStep);
    }

    public static <T> Loop<T> loopWhile(Predicate<T> pCondition, CoroutineStep<T, T> rLoopedStep) {
        return Loop.loopWhile((? super T i, Continuation<?> c) -> pCondition.test(i), rLoopedStep);
    }

    @Override
    public void runAsync(CompletableFuture<T> previousExecution, CoroutineStep<T, ?> nextStep, Continuation<?> continuation) {
        continuation.continueAccept(previousExecution, i -> this.loopAsync(i, nextStep, continuation));
    }

    @Override
    protected T execute(T input, Continuation<?> continuation) {
        while (this.pCondition.test(input, continuation)) {
            input = this.rLoopedStep.runBlocking(input, continuation);
        }
        return input;
    }

    private void loopAsync(T rInput, CoroutineStep<T, ?> rNextStep, Continuation<?> rContinuation) {
        if (this.pCondition.test(rInput, rContinuation)) {
            CompletableFuture<Object> fLoopIteration = CompletableFuture.supplyAsync(() -> rInput, rContinuation);
            this.rLoopedStep.runAsync(fLoopIteration, CodeExecution.consume(i -> this.loopAsync(i, rNextStep, rContinuation)), rContinuation);
        } else {
            rContinuation.suspend(this, rNextStep).resume(rInput);
        }
    }
}

