/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.Coroutine;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Select<I, O>
extends CoroutineStep<I, O> {
    private final List<Coroutine<? super I, ? extends O>> aCoroutines = new ArrayList<Coroutine<? super I, ? extends O>>();
    private Predicate<Continuation<?>> pSelectCritiera = c -> true;

    public Select(Collection<Coroutine<? super I, ? extends O>> rFromCoroutines) {
        if (rFromCoroutines.size() == 0) {
            throw new IllegalArgumentException("At least one coroutine to select is required");
        }
        this.aCoroutines.addAll(rFromCoroutines);
    }

    private Select(Select<I, O> rOther) {
        this.aCoroutines.addAll(rOther.aCoroutines);
        this.pSelectCritiera = rOther.pSelectCritiera;
    }

    @SafeVarargs
    public static <I, O> Select<I, O> select(Coroutine<? super I, ? extends O> ... rFromCoroutines) {
        return new Select<I, O>(Arrays.asList(rFromCoroutines));
    }

    @SafeVarargs
    public static <I, O> Select<I, O> select(CoroutineStep<? super I, ? extends O> ... rFromSteps) {
        return new Select<I, O>(Arrays.asList(rFromSteps).stream().map(rStep -> new Coroutine(rStep)).collect(Collectors.toList()));
    }

    public Select<I, O> or(Coroutine<? super I, ? extends O> rCoroutine) {
        Select<I, O> aSelect = new Select<I, O>(this);
        aSelect.aCoroutines.add(rCoroutine);
        return aSelect;
    }

    public Select<I, O> or(CoroutineStep<? super I, ? extends O> rStep) {
        Select<I, O> aSelect = new Select<I, O>(this);
        aSelect.aCoroutines.add(new Coroutine<I, O>(rStep));
        return aSelect;
    }

    @Override
    public void runAsync(CompletableFuture<I> previousExecution, CoroutineStep<O, ?> nextStep, Continuation<?> continuation) {
        continuation.continueAccept(previousExecution, rInput -> this.selectAsync(rInput, nextStep, continuation));
    }

    public Select<I, O> when(Predicate<Continuation<?>> pSelectCriteria) {
        Select<? super I, ? extends O> aSelect = new Select<I, O>(this.aCoroutines);
        aSelect.pSelectCritiera = pSelectCriteria;
        return aSelect;
    }

    @Override
    protected O execute(I input, Continuation<?> continuation) {
        return new Coroutine(this).runAsync(continuation.scope(), input).getResult();
    }

    void selectAsync(I rInput, CoroutineStep<O, ?> rNextStep, Continuation<?> rContinuation) {
        Selection aSelection = Selection.ofSingleValue(this, rNextStep, rContinuation, this.pSelectCritiera);
        rContinuation.suspendTo(aSelection);
        this.aCoroutines.forEach(rCoroutine -> aSelection.add(rCoroutine.runAsync(rContinuation.scope(), rInput)));
        aSelection.seal();
    }
}

