/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step.nio;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineException;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.Suspension;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public abstract class AsynchronousChannelStep<I, O>
extends CoroutineStep<I, O> {
    public static final RelationType<AsynchronousChannelGroup> CHANNEL_GROUP = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    static final int FIRST_OPERATION = -2;

    protected AsynchronousChannelGroup getChannelGroup(Continuation<?> continuation) {
        Executor rContextExecutor;
        AsynchronousChannelGroup channelGroup = continuation.getState(CHANNEL_GROUP);
        if (channelGroup == null && (rContextExecutor = continuation.context().getExecutor()) instanceof ExecutorService) {
            try {
                channelGroup = AsynchronousChannelGroup.withThreadPool((ExecutorService)rContextExecutor);
            }
            catch (IOException e) {
                throw new CoroutineException(e);
            }
            continuation.scope().set(CHANNEL_GROUP, channelGroup);
        }
        return channelGroup;
    }

    static {
        RelationTypes.init((Class[])new Class[]{AsynchronousChannelStep.class});
    }

    protected static class ChannelCallback<V, C extends AsynchronousChannel>
    implements CompletionHandler<V, ByteBuffer> {
        private final C channel;
        private final Suspension<ByteBuffer> suspension;
        private final ChannelOperation<C> operation;

        protected ChannelCallback(C channel, Suspension<ByteBuffer> suspension, ChannelOperation<C> operation) {
            this.channel = channel;
            this.suspension = suspension;
            this.operation = operation;
        }

        @Override
        public void completed(V result, ByteBuffer data) {
            int processed = result instanceof Integer ? (Integer)result : -2;
            try {
                if (this.operation.execute(processed, this.channel, data, this)) {
                    this.suspension.resume(data);
                }
            }
            catch (Exception e) {
                this.suspension.fail(e);
            }
        }

        @Override
        public void failed(Throwable error, ByteBuffer data) {
            this.suspension.fail(error);
        }
    }

    @FunctionalInterface
    protected static interface ChannelOperation<C extends AsynchronousChannel> {
        public boolean execute(int var1, C var2, ByteBuffer var3, ChannelCallback<Integer, C> var4) throws Exception;
    }
}

