/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step.nio;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.Coroutine;
import de.esoco.coroutine.CoroutineException;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.Suspension;
import de.esoco.coroutine.step.nio.AsynchronousChannelStep;
import de.esoco.lib.collection.CollectionUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.type.MetaTypes;

public abstract class AsynchronousFileStep
extends AsynchronousChannelStep<ByteBuffer, ByteBuffer> {
    public static final RelationType<AsynchronousFileChannel> FILE_CHANNEL = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<Long> FILE_POSITION = RelationTypes.newLongType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private final Function<Continuation<?>, AsynchronousFileChannel> getFileChannel;

    public AsynchronousFileStep(Function<Continuation<?>, AsynchronousFileChannel> getFileChannel) {
        Objects.requireNonNull(getFileChannel);
        this.getFileChannel = getFileChannel;
    }

    protected static AsynchronousFileChannel openFileChannel(String fileName, OpenOption mode, OpenOption ... extraOptions) {
        try {
            return AsynchronousFileChannel.open(new File(fileName).toPath(), (OpenOption[])CollectionUtil.join((Object[])extraOptions, (Object[])new OpenOption[]{mode}));
        }
        catch (IOException e) {
            throw new CoroutineException(e);
        }
    }

    @Override
    public void runAsync(CompletableFuture<ByteBuffer> previousExecution, CoroutineStep<ByteBuffer, ?> nextStep, Continuation<?> continuation) {
        continuation.continueAccept(previousExecution, b -> this.transferAsync((ByteBuffer)b, continuation.suspend(this, nextStep)));
    }

    @Override
    protected ByteBuffer execute(ByteBuffer input, Continuation<?> continuation) {
        try {
            AsynchronousFileChannel rChannel = this.getFileChannel(continuation);
            this.performBlockingOperation(rChannel, input);
        }
        catch (Exception e) {
            throw new CoroutineException(e);
        }
        return input;
    }

    protected AsynchronousFileChannel getFileChannel(Continuation<?> continuation) throws IOException {
        Coroutine<?, ?> rCoroutine = continuation.getCurrentCoroutine();
        AsynchronousFileChannel rChannel = (AsynchronousFileChannel)rCoroutine.get(FILE_CHANNEL);
        if (rChannel == null || !rChannel.isOpen()) {
            rChannel = this.getFileChannel.apply(continuation);
            rCoroutine.set(FILE_CHANNEL, rChannel).annotate(MetaTypes.MANAGED);
        }
        return rChannel;
    }

    protected Function<Continuation<?>, AsynchronousFileChannel> getFileChannelFactory() {
        return this.getFileChannel;
    }

    protected abstract boolean performAsyncOperation(int var1, AsynchronousFileChannel var2, ByteBuffer var3, AsynchronousChannelStep.ChannelCallback<Integer, AsynchronousFileChannel> var4) throws Exception;

    protected abstract void performBlockingOperation(AsynchronousFileChannel var1, ByteBuffer var2) throws Exception;

    private void transferAsync(ByteBuffer data, Suspension<ByteBuffer> suspension) {
        try {
            AsynchronousFileChannel channel = this.getFileChannel(suspension.continuation());
            this.performAsyncOperation(-2, channel, data, new AsynchronousChannelStep.ChannelCallback<Integer, AsynchronousFileChannel>(channel, suspension, this::performAsyncOperation));
        }
        catch (Exception e) {
            suspension.fail(e);
        }
    }

    static {
        RelationTypes.init((Class[])new Class[]{AsynchronousFileStep.class});
    }
}

