/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step.nio;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.Coroutine;
import de.esoco.coroutine.CoroutineException;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.Suspension;
import de.esoco.coroutine.step.nio.AsynchronousChannelStep;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.type.MetaTypes;

public abstract class AsynchronousSocketStep
extends AsynchronousChannelStep<ByteBuffer, ByteBuffer> {
    public static final RelationType<AsynchronousSocketChannel> SOCKET_CHANNEL = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private final Function<Continuation<?>, SocketAddress> getSocketAddress;

    public AsynchronousSocketStep(Function<Continuation<?>, SocketAddress> getSocketAddress) {
        Objects.requireNonNull(getSocketAddress);
        this.getSocketAddress = getSocketAddress;
    }

    @Override
    public void runAsync(CompletableFuture<ByteBuffer> previousExecution, CoroutineStep<ByteBuffer, ?> nextStep, Continuation<?> continuation) {
        continuation.continueAccept(previousExecution, b -> this.connectAsync((ByteBuffer)b, continuation.suspend(this, nextStep)));
    }

    @Override
    protected ByteBuffer execute(ByteBuffer input, Continuation<?> continuation) {
        try {
            AsynchronousSocketChannel channel = this.getSocketChannel(continuation);
            if (channel.getRemoteAddress() == null) {
                channel.connect(this.getSocketAddress(continuation)).get();
            }
            this.performBlockingOperation(channel, input);
        }
        catch (Exception e) {
            throw new CoroutineException(e);
        }
        return input;
    }

    protected SocketAddress getSocketAddress(Continuation<?> continuation) {
        return this.getSocketAddress.apply(continuation);
    }

    protected Function<Continuation<?>, SocketAddress> getSocketAddressFactory() {
        return this.getSocketAddress;
    }

    protected AsynchronousSocketChannel getSocketChannel(Continuation<?> continuation) throws IOException {
        Coroutine<?, ?> rCoroutine = continuation.getCurrentCoroutine();
        AsynchronousSocketChannel rChannel = (AsynchronousSocketChannel)rCoroutine.get(SOCKET_CHANNEL);
        if (rChannel == null || !rChannel.isOpen()) {
            rChannel = AsynchronousSocketChannel.open(this.getChannelGroup(continuation));
            rCoroutine.set(SOCKET_CHANNEL, rChannel).annotate(MetaTypes.MANAGED);
        }
        return rChannel;
    }

    protected abstract boolean performAsyncOperation(int var1, AsynchronousSocketChannel var2, ByteBuffer var3, AsynchronousChannelStep.ChannelCallback<Integer, AsynchronousSocketChannel> var4) throws Exception;

    protected abstract void performBlockingOperation(AsynchronousSocketChannel var1, ByteBuffer var2) throws Exception;

    private void connectAsync(ByteBuffer data, Suspension<ByteBuffer> suspension) {
        try {
            AsynchronousSocketChannel rChannel = this.getSocketChannel(suspension.continuation());
            if (rChannel.getRemoteAddress() == null) {
                SocketAddress rSocketAddress = this.getSocketAddress.apply(suspension.continuation());
                rChannel.connect(rSocketAddress, data, new AsynchronousChannelStep.ChannelCallback(rChannel, suspension, this::performAsyncOperation));
            } else {
                this.performAsyncOperation(-2, rChannel, data, new AsynchronousChannelStep.ChannelCallback<Integer, AsynchronousSocketChannel>(rChannel, suspension, this::performAsyncOperation));
            }
        }
        catch (Exception e) {
            suspension.fail(e);
        }
    }

    static {
        RelationTypes.init((Class[])new Class[]{AsynchronousSocketStep.class});
    }
}

