/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step.nio;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.step.nio.AsynchronousChannelStep;
import de.esoco.coroutine.step.nio.AsynchronousFileStep;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class FileRead
extends AsynchronousFileStep {
    private final BiPredicate<Integer, ByteBuffer> checkFinished;

    public FileRead(Function<Continuation<?>, AsynchronousFileChannel> getFileChannel, BiPredicate<Integer, ByteBuffer> checkFinished) {
        super(getFileChannel);
        this.checkFinished = checkFinished;
    }

    public static AsynchronousFileStep readFrom(Function<Continuation<?>, AsynchronousFileChannel> getFileChannel) {
        return new FileRead(getFileChannel, (r, bb) -> r != -1);
    }

    public static AsynchronousFileStep readFrom(String fileName, OpenOption ... extraOptions) {
        return FileRead.readFrom(c -> FileRead.openFileChannel(fileName, StandardOpenOption.READ, extraOptions));
    }

    public AsynchronousFileStep until(BiPredicate<Integer, ByteBuffer> checkFinished) {
        return new FileRead(this.getFileChannelFactory(), checkFinished);
    }

    @Override
    protected boolean performAsyncOperation(int bytesRead, AsynchronousFileChannel channel, ByteBuffer data, AsynchronousChannelStep.ChannelCallback<Integer, AsynchronousFileChannel> callback) throws IOException {
        long position = (Long)this.get(FILE_POSITION);
        boolean finished = false;
        if (bytesRead >= 0) {
            finished = this.checkFinished.test(bytesRead, data);
            position += (long)bytesRead;
        }
        if (bytesRead != -1 && !finished && data.hasRemaining()) {
            channel.read(data, position, data, callback);
        } else {
            this.checkErrors(data, bytesRead, finished);
            this.deleteRelation(FILE_POSITION);
            data.flip();
        }
        return finished;
    }

    @Override
    protected void performBlockingOperation(AsynchronousFileChannel channel, ByteBuffer data) throws Exception {
        boolean finished;
        int bytesRead;
        long nPosition = 0L;
        do {
            bytesRead = channel.read(data, nPosition).get();
            finished = this.checkFinished.test(bytesRead, data);
            if (bytesRead <= 0) continue;
            nPosition += (long)bytesRead;
        } while (bytesRead != -1 && !finished && data.hasRemaining());
        this.checkErrors(data, bytesRead, finished);
        data.flip();
    }

    private void checkErrors(ByteBuffer data, int bytesRead, boolean finished) throws IOException {
        if (!finished) {
            if (bytesRead == -1) {
                throw new IOException("Received data incomplete");
            }
            if (!data.hasRemaining()) {
                throw new IOException("Buffer capacity exceeded");
            }
        }
    }
}

