/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step.nio;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.step.nio.AsynchronousChannelStep;
import de.esoco.coroutine.step.nio.AsynchronousFileStep;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class FileWrite
extends AsynchronousFileStep {
    public FileWrite(Function<Continuation<?>, AsynchronousFileChannel> getFileChannel) {
        super(getFileChannel);
    }

    public static FileWrite writeTo(Function<Continuation<?>, AsynchronousFileChannel> getFileChannel) {
        return new FileWrite(getFileChannel);
    }

    public static FileWrite writeTo(String fileName, OpenOption ... extraOptions) {
        return FileWrite.writeTo(c -> FileWrite.openFileChannel(fileName, StandardOpenOption.WRITE, extraOptions));
    }

    @Override
    protected boolean performAsyncOperation(int bytesWritten, AsynchronousFileChannel channel, ByteBuffer data, AsynchronousChannelStep.ChannelCallback<Integer, AsynchronousFileChannel> callback) {
        long position = (Long)this.get(FILE_POSITION);
        if (data.hasRemaining()) {
            if (bytesWritten > 0) {
                position += (long)bytesWritten;
            }
            channel.write(data, position, data, callback);
            return false;
        }
        this.deleteRelation(FILE_POSITION);
        data.clear();
        return true;
    }

    @Override
    protected void performBlockingOperation(AsynchronousFileChannel channel, ByteBuffer data) throws InterruptedException, ExecutionException {
        long position = 0L;
        while (data.hasRemaining()) {
            position += (long)channel.write(data, position).get().intValue();
        }
        data.clear();
    }
}

