/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step.nio;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.Coroutine;
import de.esoco.coroutine.CoroutineException;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.Suspension;
import de.esoco.coroutine.step.nio.AsynchronousChannelStep;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.type.MetaTypes;

public class ServerSocketAccept
extends AsynchronousChannelStep<Void, Void> {
    public static final RelationType<AsynchronousServerSocketChannel> SERVER_SOCKET_CHANNEL = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private final Function<Continuation<?>, SocketAddress> getSocketAddress;
    private final Coroutine<AsynchronousSocketChannel, ?> requestHandler;

    public ServerSocketAccept(Function<Continuation<?>, SocketAddress> getSocketAddress, Coroutine<AsynchronousSocketChannel, ?> requestHandler) {
        Objects.requireNonNull(getSocketAddress);
        this.getSocketAddress = getSocketAddress;
        this.requestHandler = requestHandler;
    }

    public static ServerSocketAccept acceptRequestOn(Function<Continuation<?>, SocketAddress> getSocketAddress, Coroutine<AsynchronousSocketChannel, ?> requestHandler) {
        return new ServerSocketAccept(getSocketAddress, requestHandler);
    }

    @Override
    public void runAsync(CompletableFuture<Void> previousExecution, CoroutineStep<Void, ?> nextStep, Continuation<?> continuation) {
        continuation.continueAccept(previousExecution, v -> this.acceptAsync(continuation.suspend(this, nextStep)));
    }

    @Override
    protected Void execute(Void input, Continuation<?> continuation) {
        try {
            AsynchronousServerSocketChannel rChannel = this.getServerSocketChannel(continuation);
            this.requestHandler.runBlocking(continuation.scope(), rChannel.accept().get());
        }
        catch (Exception e) {
            throw new CoroutineException(e);
        }
        return null;
    }

    protected AsynchronousServerSocketChannel getServerSocketChannel(Continuation<?> continuation) throws IOException {
        Coroutine<?, ?> coroutine = continuation.getCurrentCoroutine();
        AsynchronousServerSocketChannel channel = (AsynchronousServerSocketChannel)coroutine.get(SERVER_SOCKET_CHANNEL);
        if (channel == null || !channel.isOpen()) {
            channel = AsynchronousServerSocketChannel.open(this.getChannelGroup(continuation));
            coroutine.set(SERVER_SOCKET_CHANNEL, channel).annotate(MetaTypes.MANAGED);
        }
        if (channel.getLocalAddress() == null) {
            channel.bind(this.getSocketAddress(continuation));
        }
        return channel;
    }

    protected SocketAddress getSocketAddress(Continuation<?> continuation) {
        return this.getSocketAddress.apply(continuation);
    }

    protected Function<Continuation<?>, SocketAddress> getSocketAddressFactory() {
        return this.getSocketAddress;
    }

    private void acceptAsync(Suspension<Void> suspension) {
        try {
            AsynchronousServerSocketChannel channel = this.getServerSocketChannel(suspension.continuation());
            channel.accept(null, new AcceptCallback(this.requestHandler, suspension));
        }
        catch (Exception e) {
            suspension.fail(e);
        }
    }

    static {
        RelationTypes.init((Class[])new Class[]{ServerSocketAccept.class});
    }

    protected static class AcceptCallback
    implements CompletionHandler<AsynchronousSocketChannel, Void> {
        private final Coroutine<AsynchronousSocketChannel, ?> requestHandler;
        private final Suspension<Void> suspension;

        public AcceptCallback(Coroutine<AsynchronousSocketChannel, ?> requestHandler, Suspension<Void> suspension) {
            this.requestHandler = requestHandler;
            this.suspension = suspension;
        }

        @Override
        public void completed(AsynchronousSocketChannel requestChannel, Void ignored) {
            this.requestHandler.runAsync(this.suspension.continuation().scope(), requestChannel);
            this.suspension.resume();
        }

        @Override
        public void failed(Throwable error, Void ignored) {
            this.suspension.fail(error);
        }
    }
}

