/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step.nio;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.step.nio.AsynchronousChannelStep;
import de.esoco.coroutine.step.nio.AsynchronousSocketStep;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class SocketReceive
extends AsynchronousSocketStep {
    private final BiPredicate<Integer, ByteBuffer> checkFinished;

    public SocketReceive(Function<Continuation<?>, SocketAddress> getSocketAddress, BiPredicate<Integer, ByteBuffer> checkFinished) {
        super(getSocketAddress);
        this.checkFinished = checkFinished;
    }

    public static BiPredicate<Integer, ByteBuffer> contentFullyRead() {
        return new CheckContentLength();
    }

    public static SocketReceive receiveFrom(Function<Continuation<?>, SocketAddress> getSocketAddress) {
        return new SocketReceive(getSocketAddress, (r, bb) -> true);
    }

    public static SocketReceive receiveFrom(SocketAddress socketAddress) {
        return SocketReceive.receiveFrom((Continuation<?> c) -> socketAddress);
    }

    public static SocketReceive receiveUntil(BiPredicate<Integer, ByteBuffer> checkFinished) {
        return SocketReceive.receiveFrom((SocketAddress)null).until(checkFinished);
    }

    public SocketReceive until(BiPredicate<Integer, ByteBuffer> checkFinished) {
        return new SocketReceive(this.getSocketAddressFactory(), checkFinished);
    }

    @Override
    protected boolean performAsyncOperation(int bytesProcessed, AsynchronousSocketChannel channel, ByteBuffer data, AsynchronousChannelStep.ChannelCallback<Integer, AsynchronousSocketChannel> callback) throws IOException {
        boolean finished = false;
        if (bytesProcessed >= 0) {
            finished = this.checkFinished.test(bytesProcessed, data);
        }
        if (bytesProcessed != -1 && !finished && data.hasRemaining()) {
            channel.read(data, data, callback);
        } else {
            this.checkErrors(data, bytesProcessed, finished);
            data.flip();
        }
        return finished;
    }

    @Override
    protected void performBlockingOperation(AsynchronousSocketChannel channel, ByteBuffer data) throws Exception {
        boolean finished;
        int received;
        do {
            received = channel.read(data).get();
            finished = this.checkFinished.test(received, data);
        } while (received != -1 && !finished && data.hasRemaining());
        this.checkErrors(data, received, finished);
        data.flip();
    }

    private void checkErrors(ByteBuffer data, int received, boolean finished) throws IOException {
        if (!finished) {
            if (received == -1) {
                throw new IOException("Received data incomplete");
            }
            if (!data.hasRemaining()) {
                throw new IOException("Buffer capacity exceeded");
            }
        }
    }

    static class CheckContentLength
    implements BiPredicate<Integer, ByteBuffer> {
        private static final String CONTENT_LENGTH_HEADER = "Content-Length: ";
        private int nFullLength = -1;

        CheckContentLength() {
        }

        @Override
        public boolean test(Integer nReceived, ByteBuffer buffer) {
            if (this.nFullLength == -1) {
                String sData = StandardCharsets.UTF_8.decode(buffer.duplicate()).toString();
                int nLengthPos = sData.indexOf(CONTENT_LENGTH_HEADER);
                this.nFullLength = sData.indexOf("\r\n\r\n");
                if (this.nFullLength == -1) {
                    throw new IllegalArgumentException("No HTTP header found");
                }
                if (nLengthPos == -1) {
                    throw new IllegalArgumentException("No content length found");
                }
                int nContentLength = Integer.parseInt(sData.substring(nLengthPos + CONTENT_LENGTH_HEADER.length(), sData.indexOf("\r\n", nLengthPos)));
                this.nFullLength += nContentLength + 4;
            }
            return buffer.position() >= this.nFullLength;
        }
    }
}

