/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine.step.nio;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.step.nio.AsynchronousChannelStep;
import de.esoco.coroutine.step.nio.AsynchronousSocketStep;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class SocketSend
extends AsynchronousSocketStep {
    public SocketSend(Function<Continuation<?>, SocketAddress> getSocketAddress) {
        super(getSocketAddress);
    }

    public static SocketSend sendTo(Function<Continuation<?>, SocketAddress> getSocketAddress) {
        return new SocketSend(getSocketAddress);
    }

    public static SocketSend sendTo(SocketAddress socketAddress) {
        return SocketSend.sendTo((Continuation<?> c) -> socketAddress);
    }

    @Override
    protected boolean performAsyncOperation(int bytesProcessed, AsynchronousSocketChannel channel, ByteBuffer data, AsynchronousChannelStep.ChannelCallback<Integer, AsynchronousSocketChannel> callback) {
        if (data.hasRemaining()) {
            channel.write(data, data, callback);
            return false;
        }
        data.clear();
        return true;
    }

    @Override
    protected void performBlockingOperation(AsynchronousSocketChannel channel, ByteBuffer data) throws InterruptedException, ExecutionException {
        while (data.hasRemaining()) {
            channel.write(data).get();
        }
        data.clear();
    }
}

