//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// This file is a part of the 'esoco-business' project.
// Copyright 2017 Elmar Sonnenschein, esoco GmbH, Flensburg, Germany
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//	  http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
package de.esoco.process.ui;

import static de.esoco.lib.property.ContentProperties.ICON;
import static de.esoco.lib.property.ContentProperties.IMAGE;

/**
 * The base class for the definition of images to be used in UI components.
 *
 * @author eso
 */
public abstract class UiImageDefinition<E extends UiImageDefinition<E>>
	extends UiElement<E> {

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void applyPropertiesTo(UiComponent<?, ?> component) {
		// remove properties related to image-data to prevent conflict when
		// the image type has changed
		component.remove(IMAGE, ICON);

		super.applyPropertiesTo(component);
	}
}
