//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// This file is a part of the 'esoco-business' project.
// Copyright 2018 Elmar Sonnenschein, esoco GmbH, Flensburg, Germany
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//	  http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
package de.esoco.process.ui.graphics;

/**
 * Enumeration of Font Awesome (5.1.0) icons.
 *
 * @see <a href="http://fontawesome.io">Font Awesome</a>
 */
public enum UiFontAwesomeIcon implements UiIconSupplier {
	ADDRESS_BOOK('\uF2B9'), ADDRESS_CARD('\uF2BB'), ADJUST('\uF042'),
	ALARM_CLOCK('\uF34E'), ALIGN_CENTER('\uF037'), ALIGN_JUSTIFY('\uF039'),
	ALIGN_LEFT('\uF036'), ALIGN_RIGHT('\uF038'), ALLERGIES('\uF461'),
	AMBULANCE('\uF0F9'), AMERICAN_SIGN_LANGUAGE_INTERPRETING('\uF2A3'),
	ANCHOR('\uF13D'), ANGLE_DOUBLE_DOWN('\uF103'), ANGLE_DOUBLE_LEFT('\uF100'),
	ANGLE_DOUBLE_RIGHT('\uF101'), ANGLE_DOUBLE_UP('\uF102'),
	ANGLE_DOWN('\uF107'), ANGLE_LEFT('\uF104'), ANGLE_RIGHT('\uF105'),
	ANGLE_UP('\uF106'), ANGRY('\uF556'), ARCHIVE('\uF187'), ARCHWAY('\uF557'),
	ARROW_ALT_CIRCLE_DOWN('\uF358'), ARROW_ALT_CIRCLE_LEFT('\uF359'),
	ARROW_ALT_CIRCLE_RIGHT('\uF35A'), ARROW_ALT_CIRCLE_UP('\uF35B'),
	ARROW_ALT_DOWN('\uF354'), ARROW_ALT_FROM_BOTTOM('\uF346'),
	ARROW_ALT_FROM_LEFT('\uF347'), ARROW_ALT_FROM_RIGHT('\uF348'),
	ARROW_ALT_FROM_TOP('\uF349'), ARROW_ALT_LEFT('\uF355'),
	ARROW_ALT_RIGHT('\uF356'), ARROW_ALT_SQUARE_DOWN('\uF350'),
	ARROW_ALT_SQUARE_LEFT('\uF351'), ARROW_ALT_SQUARE_RIGHT('\uF352'),
	ARROW_ALT_SQUARE_UP('\uF353'), ARROW_ALT_TO_BOTTOM('\uF34A'),
	ARROW_ALT_TO_LEFT('\uF34B'), ARROW_ALT_TO_RIGHT('\uF34C'),
	ARROW_ALT_TO_TOP('\uF34D'), ARROW_ALT_UP('\uF357'),
	ARROW_CIRCLE_DOWN('\uF0AB'), ARROW_CIRCLE_LEFT('\uF0A8'),
	ARROW_CIRCLE_RIGHT('\uF0A9'), ARROW_CIRCLE_UP('\uF0AA'),
	ARROW_DOWN('\uF063'), ARROW_FROM_BOTTOM('\uF342'),
	ARROW_FROM_LEFT('\uF343'), ARROW_FROM_RIGHT('\uF344'),
	ARROW_FROM_TOP('\uF345'), ARROW_LEFT('\uF060'), ARROW_RIGHT('\uF061'),
	ARROW_SQUARE_DOWN('\uF339'), ARROW_SQUARE_LEFT('\uF33A'),
	ARROW_SQUARE_RIGHT('\uF33B'), ARROW_SQUARE_UP('\uF33C'),
	ARROW_TO_BOTTOM('\uF33D'), ARROW_TO_LEFT('\uF33E'),
	ARROW_TO_RIGHT('\uF340'), ARROW_TO_TOP('\uF341'), ARROW_UP('\uF062'),
	ARROWS('\uF047'), ARROWS_ALT('\uF0B2'), ARROWS_ALT_H('\uF337'),
	ARROWS_ALT_V('\uF338'), ARROWS_H('\uF07E'), ARROWS_V('\uF07D'),
	ASSISTIVE_LISTENING_SYSTEMS('\uF2A2'), ASTERISK('\uF069'), AT('\uF1FA'),
	ATLAS('\uF558'), AUDIO_DESCRIPTION('\uF29E'), AWARD('\uF559'),
	BACKSPACE('\uF55A'), BACKWARD('\uF04A'), BADGE('\uF335'),
	BADGE_CHECK('\uF336'), BALANCE_SCALE('\uF24E'),
	BALANCE_SCALE_LEFT('\uF515'), BALANCE_SCALE_RIGHT('\uF516'), BAN('\uF05E'),
	BAND_AID('\uF462'), BARCODE('\uF02A'), BARCODE_ALT('\uF463'),
	BARCODE_READ('\uF464'), BARCODE_SCAN('\uF465'), BARS('\uF0C9'),
	BASEBALL('\uF432'), BASEBALL_BALL('\uF433'), BASKETBALL_BALL('\uF434'),
	BASKETBALL_HOOP('\uF435'), BATH('\uF2CD'), BATTERY_BOLT('\uF376'),
	BATTERY_EMPTY('\uF244'), BATTERY_FULL('\uF240'), BATTERY_HALF('\uF242'),
	BATTERY_QUARTER('\uF243'), BATTERY_SLASH('\uF377'),
	BATTERY_THREE_QUARTERS('\uF241'), BED('\uF236'), BEER('\uF0FC'),
	BELL('\uF0F3'), BELL_SLASH('\uF1F6'), BEZIER_CURVE('\uF55B'),
	BICYCLE('\uF206'), BINOCULARS('\uF1E5'), BIRTHDAY_CAKE('\uF1FD'),
	BLANKET('\uF498'), BLENDER('\uF517'), BLIND('\uF29D'), BOLD('\uF032'),
	BOLT('\uF0E7'), BOMB('\uF1E2'), BONG('\uF55C'), BOOK('\uF02D'),
	BOOK_HEART('\uF499'), BOOK_OPEN('\uF518'), BOOKMARK('\uF02E'),
	BOWLING_BALL('\uF436'), BOWLING_PINS('\uF437'), BOX('\uF466'),
	BOX_ALT('\uF49A'), BOX_CHECK('\uF467'), BOX_FRAGILE('\uF49B'),
	BOX_FULL('\uF49C'), BOX_HEART('\uF49D'), BOX_OPEN('\uF49E'),
	BOX_UP('\uF49F'), BOX_USD('\uF4A0'), BOXES('\uF468'), BOXES_ALT('\uF4A1'),
	BOXING_GLOVE('\uF438'), BRAILLE('\uF2A1'), BRIEFCASE('\uF0B1'),
	BRIEFCASE_MEDICAL('\uF469'), BROADCAST_TOWER('\uF519'), BROOM('\uF51A'),
	BROWSER('\uF37E'), BRUSH('\uF55D'), BUG('\uF188'), BUILDING('\uF1AD'),
	BULLHORN('\uF0A1'), BULLSEYE('\uF140'), BURN('\uF46A'), BUS('\uF207'),
	BUS_ALT('\uF55E'), CALCULATOR('\uF1EC'), CALENDAR('\uF133'),
	CALENDAR_ALT('\uF073'), CALENDAR_CHECK('\uF274'), CALENDAR_EDIT('\uF333'),
	CALENDAR_EXCLAMATION('\uF334'), CALENDAR_MINUS('\uF272'),
	CALENDAR_PLUS('\uF271'), CALENDAR_TIMES('\uF273'), CAMERA('\uF030'),
	CAMERA_ALT('\uF332'), CAMERA_RETRO('\uF083'), CANNABIS('\uF55F'),
	CAPSULES('\uF46B'), CAR('\uF1B9'), CARET_CIRCLE_DOWN('\uF32D'),
	CARET_CIRCLE_LEFT('\uF32E'), CARET_CIRCLE_RIGHT('\uF330'),
	CARET_CIRCLE_UP('\uF331'), CARET_DOWN('\uF0D7'), CARET_LEFT('\uF0D9'),
	CARET_RIGHT('\uF0DA'), CARET_SQUARE_DOWN('\uF150'),
	CARET_SQUARE_LEFT('\uF191'), CARET_SQUARE_RIGHT('\uF152'),
	CARET_SQUARE_UP('\uF151'), CARET_UP('\uF0D8'), CART_ARROW_DOWN('\uF218'),
	CART_PLUS('\uF217'), CERTIFICATE('\uF0A3'), CHALKBOARD('\uF51B'),
	CHALKBOARD_TEACHER('\uF51C'), CHART_AREA('\uF1FE'), CHART_BAR('\uF080'),
	CHART_LINE('\uF201'), CHART_PIE('\uF200'), CHECK('\uF00C'),
	CHECK_CIRCLE('\uF058'), CHECK_DOUBLE('\uF560'), CHECK_SQUARE('\uF14A'),
	CHESS('\uF439'), CHESS_BISHOP('\uF43A'), CHESS_BISHOP_ALT('\uF43B'),
	CHESS_BOARD('\uF43C'), CHESS_CLOCK('\uF43D'), CHESS_CLOCK_ALT('\uF43E'),
	CHESS_KING('\uF43F'), CHESS_KING_ALT('\uF440'), CHESS_KNIGHT('\uF441'),
	CHESS_KNIGHT_ALT('\uF442'), CHESS_PAWN('\uF443'), CHESS_PAWN_ALT('\uF444'),
	CHESS_QUEEN('\uF445'), CHESS_QUEEN_ALT('\uF446'), CHESS_ROOK('\uF447'),
	CHESS_ROOK_ALT('\uF448'), CHEVRON_CIRCLE_DOWN('\uF13A'),
	CHEVRON_CIRCLE_LEFT('\uF137'), CHEVRON_CIRCLE_RIGHT('\uF138'),
	CHEVRON_CIRCLE_UP('\uF139'), CHEVRON_DOUBLE_DOWN('\uF322'),
	CHEVRON_DOUBLE_LEFT('\uF323'), CHEVRON_DOUBLE_RIGHT('\uF324'),
	CHEVRON_DOUBLE_UP('\uF325'), CHEVRON_DOWN('\uF078'),
	CHEVRON_LEFT('\uF053'),
	CHEVRON_RIGHT('\uF054'), CHEVRON_SQUARE_DOWN('\uF329'),
	CHEVRON_SQUARE_LEFT('\uF32A'), CHEVRON_SQUARE_RIGHT('\uF32B'),
	CHEVRON_SQUARE_UP('\uF32C'), CHEVRON_UP('\uF077'), CHILD('\uF1AE'),
	CHURCH('\uF51D'), CIRCLE('\uF111'), CIRCLE_NOTCH('\uF1CE'),
	CLIPBOARD('\uF328'), CLIPBOARD_CHECK('\uF46C'), CLIPBOARD_LIST('\uF46D'),
	CLOCK('\uF017'), CLONE('\uF24D'), CLOSED_CAPTIONING('\uF20A'),
	CLOUD('\uF0C2'), CLOUD_DOWNLOAD('\uF0ED'), CLOUD_DOWNLOAD_ALT('\uF381'),
	CLOUD_UPLOAD('\uF0EE'), CLOUD_UPLOAD_ALT('\uF382'), CLUB('\uF327'),
	COCKTAIL('\uF561'), CODE('\uF121'), CODE_BRANCH('\uF126'),
	CODE_COMMIT('\uF386'), CODE_MERGE('\uF387'), COFFEE('\uF0F4'),
	COG('\uF013'), COGS('\uF085'), COINS('\uF51E'), COLUMNS('\uF0DB'),
	COMMENT('\uF075'), COMMENT_ALT('\uF27A'), COMMENT_ALT_CHECK('\uF4A2'),
	COMMENT_ALT_DOTS('\uF4A3'), COMMENT_ALT_EDIT('\uF4A4'),
	COMMENT_ALT_EXCLAMATION('\uF4A5'), COMMENT_ALT_LINES('\uF4A6'),
	COMMENT_ALT_MINUS('\uF4A7'), COMMENT_ALT_PLUS('\uF4A8'),
	COMMENT_ALT_SLASH('\uF4A9'), COMMENT_ALT_SMILE('\uF4AA'),
	COMMENT_ALT_TIMES('\uF4AB'), COMMENT_CHECK('\uF4AC'),
	COMMENT_DOTS('\uF4AD'), COMMENT_EDIT('\uF4AE'),
	COMMENT_EXCLAMATION('\uF4AF'), COMMENT_LINES('\uF4B0'),
	COMMENT_MINUS('\uF4B1'), COMMENT_PLUS('\uF4B2'), COMMENT_SLASH('\uF4B3'),
	COMMENT_SMILE('\uF4B4'), COMMENT_TIMES('\uF4B5'), COMMENTS('\uF086'),
	COMMENTS_ALT('\uF4B6'), COMPACT_DISC('\uF51F'), COMPASS('\uF14E'),
	COMPRESS('\uF066'), COMPRESS_ALT('\uF422'), COMPRESS_WIDE('\uF326'),
	CONCIERGE_BELL('\uF562'), CONTAINER_STORAGE('\uF4B7'),
	CONVEYOR_BELT('\uF46E'), CONVEYOR_BELT_ALT('\uF46F'), COOKIE('\uF563'),
	COOKIE_BITE('\uF564'), COPY('\uF0C5'), COPYRIGHT('\uF1F9'),
	COUCH('\uF4B8'),
	CREDIT_CARD('\uF09D'), CREDIT_CARD_BLANK('\uF389'),
	CREDIT_CARD_FRONT('\uF38A'), CRICKET('\uF449'), CROP('\uF125'),
	CROP_ALT('\uF565'), CROSSHAIRS('\uF05B'), CROW('\uF520'), CROWN('\uF521'),
	CUBE('\uF1B2'), CUBES('\uF1B3'), CURLING('\uF44A'), CUT('\uF0C4'),
	DATABASE('\uF1C0'), DEAF('\uF2A4'), DESKTOP('\uF108'),
	DESKTOP_ALT('\uF390'), DIAGNOSES('\uF470'), DIAMOND('\uF219'),
	DICE('\uF522'), DICE_FIVE('\uF523'), DICE_FOUR('\uF524'),
	DICE_ONE('\uF525'), DICE_SIX('\uF526'), DICE_THREE('\uF527'),
	DICE_TWO('\uF528'), DIGITAL_TACHOGRAPH('\uF566'), DIVIDE('\uF529'),
	DIZZY('\uF567'), DNA('\uF471'), DOLLAR_SIGN('\uF155'), DOLLY('\uF472'),
	DOLLY_EMPTY('\uF473'), DOLLY_FLATBED('\uF474'),
	DOLLY_FLATBED_ALT('\uF475'),
	DOLLY_FLATBED_EMPTY('\uF476'), DONATE('\uF4B9'), DOOR_CLOSED('\uF52A'),
	DOOR_OPEN('\uF52B'), DOT_CIRCLE('\uF192'), DOVE('\uF4BA'),
	DOWNLOAD('\uF019'), DRAFTING_COMPASS('\uF568'), DRUM('\uF569'),
	DRUM_STEELPAN('\uF56A'), DUMBBELL('\uF44B'), EDIT('\uF044'),
	EJECT('\uF052'), ELLIPSIS_H('\uF141'), ELLIPSIS_H_ALT('\uF39B'),
	ELLIPSIS_V('\uF142'), ELLIPSIS_V_ALT('\uF39C'), ENVELOPE('\uF0E0'),
	ENVELOPE_OPEN('\uF2B6'), ENVELOPE_SQUARE('\uF199'), EQUALS('\uF52C'),
	ERASER('\uF12D'), EURO_SIGN('\uF153'), EXCHANGE('\uF0EC'),
	EXCHANGE_ALT('\uF362'), EXCLAMATION('\uF12A'),
	EXCLAMATION_CIRCLE('\uF06A'),
	EXCLAMATION_SQUARE('\uF321'), EXCLAMATION_TRIANGLE('\uF071'),
	EXPAND('\uF065'), EXPAND_ALT('\uF424'), EXPAND_ARROWS('\uF31D'),
	EXPAND_ARROWS_ALT('\uF31E'), EXPAND_WIDE('\uF320'),
	EXTERNAL_LINK('\uF08E'),
	EXTERNAL_LINK_ALT('\uF35D'), EXTERNAL_LINK_SQUARE('\uF14C'),
	EXTERNAL_LINK_SQUARE_ALT('\uF360'), EYE('\uF06E'), EYE_DROPPER('\uF1FB'),
	EYE_SLASH('\uF070'), FAST_BACKWARD('\uF049'), FAST_FORWARD('\uF050'),
	FAX('\uF1AC'), FEATHER('\uF52D'), FEATHER_ALT('\uF56B'), FEMALE('\uF182'),
	FIELD_HOCKEY('\uF44C'), FIGHTER_JET('\uF0FB'), FILE('\uF15B'),
	FILE_ALT('\uF15C'), FILE_ARCHIVE('\uF1C6'), FILE_AUDIO('\uF1C7'),
	FILE_CHECK('\uF316'), FILE_CODE('\uF1C9'), FILE_CONTRACT('\uF56C'),
	FILE_DOWNLOAD('\uF56D'), FILE_EDIT('\uF31C'), FILE_EXCEL('\uF1C3'),
	FILE_EXCLAMATION('\uF31A'), FILE_EXPORT('\uF56E'), FILE_IMAGE('\uF1C5'),
	FILE_IMPORT('\uF56F'), FILE_INVOICE('\uF570'),
	FILE_INVOICE_DOLLAR('\uF571'), FILE_MEDICAL('\uF477'),
	FILE_MEDICAL_ALT('\uF478'), FILE_MINUS('\uF318'), FILE_PDF('\uF1C1'),
	FILE_PLUS('\uF319'), FILE_POWERPOINT('\uF1C4'),
	FILE_PRESCRIPTION('\uF572'),
	FILE_SIGNATURE('\uF573'), FILE_TIMES('\uF317'), FILE_UPLOAD('\uF574'),
	FILE_VIDEO('\uF1C8'), FILE_WORD('\uF1C2'), FILL('\uF575'),
	FILL_DRIP('\uF576'), FILM('\uF008'), FILM_ALT('\uF3A0'), FILTER('\uF0B0'),
	FINGERPRINT('\uF577'), FIRE('\uF06D'), FIRE_EXTINGUISHER('\uF134'),
	FIRST_AID('\uF479'), FISH('\uF578'), FLAG('\uF024'),
	FLAG_CHECKERED('\uF11E'), FLASK('\uF0C3'), FLUSHED('\uF579'),
	FOLDER('\uF07B'), FOLDER_OPEN('\uF07C'), FONT('\uF031'),
	FONT_AWESOME_LOGO_FULL('\uF4E6'), FOOTBALL_BALL('\uF44E'),
	FOOTBALL_HELMET('\uF44F'), FORKLIFT('\uF47A'), FORWARD('\uF04E'),
	FRAGILE('\uF4BB'), FROG('\uF52E'), FROWN('\uF119'), FROWN_OPEN('\uF57A'),
	FUTBOL('\uF1E3'), GAMEPAD('\uF11B'), GAS_PUMP('\uF52F'), GAVEL('\uF0E3'),
	GEM('\uF3A5'), GENDERLESS('\uF22D'), GIFT('\uF06B'),
	GLASS_MARTINI('\uF000'), GLASS_MARTINI_ALT('\uF57B'), GLASSES('\uF530'),
	GLOBE('\uF0AC'), GLOBE_AFRICA('\uF57C'), GLOBE_AMERICAS('\uF57D'),
	GLOBE_ASIA('\uF57E'), GOLF_BALL('\uF450'), GOLF_CLUB('\uF451'),
	GRADUATION_CAP('\uF19D'), GREATER_THAN('\uF531'),
	GREATER_THAN_EQUAL('\uF532'), GRIMACE('\uF57F'), GRIN('\uF580'),
	GRIN_ALT('\uF581'), GRIN_BEAM('\uF582'), GRIN_BEAM_SWEAT('\uF583'),
	GRIN_HEARTS('\uF584'), GRIN_SQUINT('\uF585'), GRIN_SQUINT_TEARS('\uF586'),
	GRIN_STARS('\uF587'), GRIN_TEARS('\uF588'), GRIN_TONGUE('\uF589'),
	GRIN_TONGUE_SQUINT('\uF58A'), GRIN_TONGUE_WINK('\uF58B'),
	GRIN_WINK('\uF58C'), GRIP_HORIZONTAL('\uF58D'), GRIP_VERTICAL('\uF58E'),
	H_SQUARE('\uF0FD'), H1('\uF313'), H2('\uF314'), H3('\uF315'),
	HAND_HEART('\uF4BC'), HAND_HOLDING('\uF4BD'), HAND_HOLDING_BOX('\uF47B'),
	HAND_HOLDING_HEART('\uF4BE'), HAND_HOLDING_SEEDLING('\uF4BF'),
	HAND_HOLDING_USD('\uF4C0'), HAND_HOLDING_WATER('\uF4C1'),
	HAND_LIZARD('\uF258'), HAND_PAPER('\uF256'), HAND_PEACE('\uF25B'),
	HAND_POINT_DOWN('\uF0A7'), HAND_POINT_LEFT('\uF0A5'),
	HAND_POINT_RIGHT('\uF0A4'), HAND_POINT_UP('\uF0A6'),
	HAND_POINTER('\uF25A'),
	HAND_RECEIVING('\uF47C'), HAND_ROCK('\uF255'), HAND_SCISSORS('\uF257'),
	HAND_SPOCK('\uF259'), HANDS('\uF4C2'), HANDS_HEART('\uF4C3'),
	HANDS_HELPING('\uF4C4'), HANDS_USD('\uF4C5'), HANDSHAKE('\uF2B5'),
	HANDSHAKE_ALT('\uF4C6'), HASHTAG('\uF292'), HDD('\uF0A0'),
	HEADING('\uF1DC'), HEADPHONES('\uF025'), HEADPHONES_ALT('\uF58F'),
	HEADSET('\uF590'), HEART('\uF004'), HEART_CIRCLE('\uF4C7'),
	HEART_SQUARE('\uF4C8'), HEARTBEAT('\uF21E'), HELICOPTER('\uF533'),
	HEXAGON('\uF312'), HIGHLIGHTER('\uF591'), HISTORY('\uF1DA'),
	HOCKEY_PUCK('\uF453'), HOCKEY_STICKS('\uF454'), HOME('\uF015'),
	HOME_HEART('\uF4C9'), HOSPITAL('\uF0F8'), HOSPITAL_ALT('\uF47D'),
	HOSPITAL_SYMBOL('\uF47E'), HOT_TUB('\uF593'), HOTEL('\uF594'),
	HOURGLASS('\uF254'), HOURGLASS_END('\uF253'), HOURGLASS_HALF('\uF252'),
	HOURGLASS_START('\uF251'), I_CURSOR('\uF246'), ID_BADGE('\uF2C1'),
	ID_CARD('\uF2C2'), ID_CARD_ALT('\uF47F'), IMAGE('\uF03E'),
	IMAGES('\uF302'),
	INBOX('\uF01C'), INBOX_IN('\uF310'), INBOX_OUT('\uF311'), INDENT('\uF03C'),
	INDUSTRY('\uF275'), INDUSTRY_ALT('\uF3B3'), INFINITY('\uF534'),
	INFO('\uF129'), INFO_CIRCLE('\uF05A'), INFO_SQUARE('\uF30F'),
	INVENTORY('\uF480'), ITALIC('\uF033'), JACK_O_LANTERN('\uF30E'),
	JOINT('\uF595'), KEY('\uF084'), KEYBOARD('\uF11C'), KISS('\uF596'),
	KISS_BEAM('\uF597'), KISS_WINK_HEART('\uF598'), KIWI_BIRD('\uF535'),
	LAMP('\uF4CA'), LANGUAGE('\uF1AB'), LAPTOP('\uF109'), LAUGH('\uF599'),
	LAUGH_BEAM('\uF59A'), LAUGH_SQUINT('\uF59B'), LAUGH_WINK('\uF59C'),
	LEAF('\uF06C'), LEAF_HEART('\uF4CB'), LEMON('\uF094'), LESS_THAN('\uF536'),
	LESS_THAN_EQUAL('\uF537'), LEVEL_DOWN('\uF149'), LEVEL_DOWN_ALT('\uF3BE'),
	LEVEL_UP('\uF148'), LEVEL_UP_ALT('\uF3BF'), LIFE_RING('\uF1CD'),
	LIGHTBULB('\uF0EB'), LINK('\uF0C1'), LIRA_SIGN('\uF195'), LIST('\uF03A'),
	LIST_ALT('\uF022'), LIST_OL('\uF0CB'), LIST_UL('\uF0CA'),
	LOCATION_ARROW('\uF124'), LOCK('\uF023'), LOCK_ALT('\uF30D'),
	LOCK_OPEN('\uF3C1'), LOCK_OPEN_ALT('\uF3C2'),
	LONG_ARROW_ALT_DOWN('\uF309'),
	LONG_ARROW_ALT_LEFT('\uF30A'), LONG_ARROW_ALT_RIGHT('\uF30B'),
	LONG_ARROW_ALT_UP('\uF30C'), LONG_ARROW_DOWN('\uF175'),
	LONG_ARROW_LEFT('\uF177'), LONG_ARROW_RIGHT('\uF178'),
	LONG_ARROW_UP('\uF176'), LOVESEAT('\uF4CC'), LOW_VISION('\uF2A8'),
	LUCHADOR('\uF455'), LUGGAGE_CART('\uF59D'), MAGIC('\uF0D0'),
	MAGNET('\uF076'), MALE('\uF183'), MAP('\uF279'), MAP_MARKED('\uF59F'),
	MAP_MARKED_ALT('\uF5A0'), MAP_MARKER('\uF041'), MAP_MARKER_ALT('\uF3C5'),
	MAP_PIN('\uF276'), MAP_SIGNS('\uF277'), MARKER('\uF5A1'), MARS('\uF222'),
	MARS_DOUBLE('\uF227'), MARS_STROKE('\uF229'), MARS_STROKE_H('\uF22B'),
	MARS_STROKE_V('\uF22A'), MEDAL('\uF5A2'), MEDKIT('\uF0FA'), MEH('\uF11A'),
	MEH_BLANK('\uF5A4'), MEH_ROLLING_EYES('\uF5A5'), MEMORY('\uF538'),
	MERCURY('\uF223'), MICROCHIP('\uF2DB'), MICROPHONE('\uF130'),
	MICROPHONE_ALT('\uF3C9'), MICROPHONE_ALT_SLASH('\uF539'),
	MICROPHONE_SLASH('\uF131'), MINUS('\uF068'), MINUS_CIRCLE('\uF056'),
	MINUS_HEXAGON('\uF307'), MINUS_OCTAGON('\uF308'), MINUS_SQUARE('\uF146'),
	MOBILE('\uF10B'), MOBILE_ALT('\uF3CD'), MOBILE_ANDROID('\uF3CE'),
	MOBILE_ANDROID_ALT('\uF3CF'), MONEY_BILL('\uF0D6'),
	MONEY_BILL_ALT('\uF3D1'), MONEY_BILL_WAVE('\uF53A'),
	MONEY_BILL_WAVE_ALT('\uF53B'), MONEY_CHECK('\uF53C'),
	MONEY_CHECK_ALT('\uF53D'), MONUMENT('\uF5A6'), MOON('\uF186'),
	MORTAR_PESTLE('\uF5A7'), MOTORCYCLE('\uF21C'), MOUSE_POINTER('\uF245'),
	MUSIC('\uF001'), NEUTER('\uF22C'), NEWSPAPER('\uF1EA'),
	NOT_EQUAL('\uF53E'),
	NOTES_MEDICAL('\uF481'), OBJECT_GROUP('\uF247'), OBJECT_UNGROUP('\uF248'),
	OCTAGON('\uF306'), OUTDENT('\uF03B'), PAINT_BRUSH('\uF1FC'),
	PAINT_BRUSH_ALT('\uF5A9'), PAINT_ROLLER('\uF5AA'), PALETTE('\uF53F'),
	PALLET('\uF482'), PALLET_ALT('\uF483'), PAPER_PLANE('\uF1D8'),
	PAPERCLIP('\uF0C6'), PARACHUTE_BOX('\uF4CD'), PARAGRAPH('\uF1DD'),
	PARKING('\uF540'), PASSPORT('\uF5AB'), PASTE('\uF0EA'), PAUSE('\uF04C'),
	PAUSE_CIRCLE('\uF28B'), PAW('\uF1B0'), PEN('\uF304'), PEN_ALT('\uF305'),
	PEN_FANCY('\uF5AC'), PEN_NIB('\uF5AD'), PEN_SQUARE('\uF14B'),
	PENCIL('\uF040'), PENCIL_ALT('\uF303'), PENCIL_RULER('\uF5AE'),
	PENNANT('\uF456'), PEOPLE_CARRY('\uF4CE'), PERCENT('\uF295'),
	PERCENTAGE('\uF541'), PERSON_CARRY('\uF4CF'), PERSON_DOLLY('\uF4D0'),
	PERSON_DOLLY_EMPTY('\uF4D1'), PHONE('\uF095'), PHONE_PLUS('\uF4D2'),
	PHONE_SLASH('\uF3DD'), PHONE_SQUARE('\uF098'), PHONE_VOLUME('\uF2A0'),
	PIGGY_BANK('\uF4D3'), PILLS('\uF484'), PLANE('\uF072'),
	PLANE_ALT('\uF3DE'),
	PLANE_ARRIVAL('\uF5AF'), PLANE_DEPARTURE('\uF5B0'), PLAY('\uF04B'),
	PLAY_CIRCLE('\uF144'), PLUG('\uF1E6'), PLUS('\uF067'),
	PLUS_CIRCLE('\uF055'), PLUS_HEXAGON('\uF300'), PLUS_OCTAGON('\uF301'),
	PLUS_SQUARE('\uF0FE'), PODCAST('\uF2CE'), POO('\uF2FE'),
	PORTRAIT('\uF3E0'),
	POUND_SIGN('\uF154'), POWER_OFF('\uF011'), PRESCRIPTION('\uF5B1'),
	PRESCRIPTION_BOTTLE('\uF485'), PRESCRIPTION_BOTTLE_ALT('\uF486'),
	PRINT('\uF02F'), PROCEDURES('\uF487'), PROJECT_DIAGRAM('\uF542'),
	PUZZLE_PIECE('\uF12E'), QRCODE('\uF029'), QUESTION('\uF128'),
	QUESTION_CIRCLE('\uF059'), QUESTION_SQUARE('\uF2FD'), QUIDDITCH('\uF458'),
	QUOTE_LEFT('\uF10D'), QUOTE_RIGHT('\uF10E'), RACQUET('\uF45A'),
	RAMP_LOADING('\uF4D4'), RANDOM('\uF074'), RECEIPT('\uF543'),
	RECTANGLE_LANDSCAPE('\uF2FA'), RECTANGLE_PORTRAIT('\uF2FB'),
	RECTANGLE_WIDE('\uF2FC'), RECYCLE('\uF1B8'), REDO('\uF01E'),
	REDO_ALT('\uF2F9'), REGISTERED('\uF25D'), REPEAT('\uF363'),
	REPEAT_1('\uF365'), REPEAT_1_ALT('\uF366'), REPEAT_ALT('\uF364'),
	REPLY('\uF3E5'), REPLY_ALL('\uF122'), RETWEET('\uF079'),
	RETWEET_ALT('\uF361'), RIBBON('\uF4D6'), ROAD('\uF018'), ROBOT('\uF544'),
	ROCKET('\uF135'), ROUTE('\uF4D7'), RSS('\uF09E'), RSS_SQUARE('\uF143'),
	RUBLE_SIGN('\uF158'), RULER('\uF545'), RULER_COMBINED('\uF546'),
	RULER_HORIZONTAL('\uF547'), RULER_VERTICAL('\uF548'), RUPEE_SIGN('\uF156'),
	SAD_CRY('\uF5B3'), SAD_TEAR('\uF5B4'), SAVE('\uF0C7'), SCANNER('\uF488'),
	SCANNER_KEYBOARD('\uF489'), SCANNER_TOUCHSCREEN('\uF48A'),
	SCHOOL('\uF549'),
	SCREWDRIVER('\uF54A'), SCRUBBER('\uF2F8'), SEARCH('\uF002'),
	SEARCH_MINUS('\uF010'), SEARCH_PLUS('\uF00E'), SEEDLING('\uF4D8'),
	SERVER('\uF233'), SHARE('\uF064'), SHARE_ALL('\uF367'),
	SHARE_ALT('\uF1E0'),
	SHARE_ALT_SQUARE('\uF1E1'), SHARE_SQUARE('\uF14D'), SHEKEL_SIGN('\uF20B'),
	SHIELD('\uF132'), SHIELD_ALT('\uF3ED'), SHIELD_CHECK('\uF2F7'),
	SHIP('\uF21A'), SHIPPING_FAST('\uF48B'), SHIPPING_TIMED('\uF48C'),
	SHOE_PRINTS('\uF54B'), SHOPPING_BAG('\uF290'), SHOPPING_BASKET('\uF291'),
	SHOPPING_CART('\uF07A'), SHOWER('\uF2CC'), SHUTTLE_VAN('\uF5B6'),
	SHUTTLECOCK('\uF45B'), SIGN('\uF4D9'), SIGN_IN('\uF090'),
	SIGN_IN_ALT('\uF2F6'), SIGN_LANGUAGE('\uF2A7'), SIGN_OUT('\uF08B'),
	SIGN_OUT_ALT('\uF2F5'), SIGNAL('\uF012'), SIGNATURE('\uF5B7'),
	SITEMAP('\uF0E8'), SKULL('\uF54C'), SLIDERS_H('\uF1DE'),
	SLIDERS_H_SQUARE('\uF3F0'), SLIDERS_V('\uF3F1'),
	SLIDERS_V_SQUARE('\uF3F2'),
	SMILE('\uF118'), SMILE_BEAM('\uF5B8'), SMILE_PLUS('\uF5B9'),
	SMILE_WINK('\uF4DA'), SMOKING('\uF48D'), SMOKING_BAN('\uF54D'),
	SNOWFLAKE('\uF2DC'), SOLAR_PANEL('\uF5BA'), SORT('\uF0DC'),
	SORT_ALPHA_DOWN('\uF15D'), SORT_ALPHA_UP('\uF15E'),
	SORT_AMOUNT_DOWN('\uF160'), SORT_AMOUNT_UP('\uF161'), SORT_DOWN('\uF0DD'),
	SORT_NUMERIC_DOWN('\uF162'), SORT_NUMERIC_UP('\uF163'), SORT_UP('\uF0DE'),
	SPA('\uF5BB'), SPACE_SHUTTLE('\uF197'), SPADE('\uF2F4'), SPINNER('\uF110'),
	SPINNER_THIRD('\uF3F4'), SPLOTCH('\uF5BC'), SPRAY_CAN('\uF5BD'),
	SQUARE('\uF0C8'), SQUARE_FULL('\uF45C'), STAMP('\uF5BF'), STAR('\uF005'),
	STAR_EXCLAMATION('\uF2F3'), STAR_HALF('\uF089'), STAR_HALF_ALT('\uF5C0'),
	STEP_BACKWARD('\uF048'), STEP_FORWARD('\uF051'), STETHOSCOPE('\uF0F1'),
	STICKY_NOTE('\uF249'), STOP('\uF04D'), STOP_CIRCLE('\uF28D'),
	STOPWATCH('\uF2F2'), STORE('\uF54E'), STORE_ALT('\uF54F'),
	STREAM('\uF550'),
	STREET_VIEW('\uF21D'), STRIKETHROUGH('\uF0CC'), STROOPWAFEL('\uF551'),
	SUBSCRIPT('\uF12C'), SUBWAY('\uF239'), SUITCASE('\uF0F2'),
	SUITCASE_ROLLING('\uF5C1'), SUN('\uF185'), SUPERSCRIPT('\uF12B'),
	SURPRISE('\uF5C2'), SWATCHBOOK('\uF5C3'), SWIMMER('\uF5C4'),
	SWIMMING_POOL('\uF5C5'), SYNC('\uF021'), SYNC_ALT('\uF2F1'),
	SYRINGE('\uF48E'), TABLE('\uF0CE'), TABLE_TENNIS('\uF45D'),
	TABLET('\uF10A'), TABLET_ALT('\uF3FA'), TABLET_ANDROID('\uF3FB'),
	TABLET_ANDROID_ALT('\uF3FC'), TABLET_RUGGED('\uF48F'), TABLETS('\uF490'),
	TACHOMETER('\uF0E4'), TACHOMETER_ALT('\uF3FD'), TAG('\uF02B'),
	TAGS('\uF02C'), TAPE('\uF4DB'), TASKS('\uF0AE'), TAXI('\uF1BA'),
	TENNIS_BALL('\uF45E'), TERMINAL('\uF120'), TEXT_HEIGHT('\uF034'),
	TEXT_WIDTH('\uF035'), TH('\uF00A'), TH_LARGE('\uF009'), TH_LIST('\uF00B'),
	THERMOMETER('\uF491'), THERMOMETER_EMPTY('\uF2CB'),
	THERMOMETER_FULL('\uF2C7'), THERMOMETER_HALF('\uF2C9'),
	THERMOMETER_QUARTER('\uF2CA'), THERMOMETER_THREE_QUARTERS('\uF2C8'),
	THUMBS_DOWN('\uF165'), THUMBS_UP('\uF164'), THUMBTACK('\uF08D'),
	TICKET('\uF145'), TICKET_ALT('\uF3FF'), TIMES('\uF00D'),
	TIMES_CIRCLE('\uF057'), TIMES_HEXAGON('\uF2EE'), TIMES_OCTAGON('\uF2F0'),
	TIMES_SQUARE('\uF2D3'), TINT('\uF043'), TINT_SLASH('\uF5C7'),
	TIRED('\uF5C8'), TOGGLE_OFF('\uF204'), TOGGLE_ON('\uF205'),
	TOOLBOX('\uF552'), TOOTH('\uF5C9'), TRADEMARK('\uF25C'), TRAIN('\uF238'),
	TRANSGENDER('\uF224'), TRANSGENDER_ALT('\uF225'), TRASH('\uF1F8'),
	TRASH_ALT('\uF2ED'), TREE('\uF1BB'), TREE_ALT('\uF400'),
	TRIANGLE('\uF2EC'),
	TROPHY('\uF091'), TROPHY_ALT('\uF2EB'), TRUCK('\uF0D1'),
	TRUCK_CONTAINER('\uF4DC'), TRUCK_COUCH('\uF4DD'), TRUCK_LOADING('\uF4DE'),
	TRUCK_MOVING('\uF4DF'), TRUCK_RAMP('\uF4E0'), TSHIRT('\uF553'),
	TTY('\uF1E4'), TV('\uF26C'), TV_RETRO('\uF401'), UMBRELLA('\uF0E9'),
	UMBRELLA_BEACH('\uF5CA'), UNDERLINE('\uF0CD'), UNDO('\uF0E2'),
	UNDO_ALT('\uF2EA'), UNIVERSAL_ACCESS('\uF29A'), UNIVERSITY('\uF19C'),
	UNLINK('\uF127'), UNLOCK('\uF09C'), UNLOCK_ALT('\uF13E'), UPLOAD('\uF093'),
	USD_CIRCLE('\uF2E8'), USD_SQUARE('\uF2E9'), USER('\uF007'),
	USER_ALT('\uF406'), USER_ALT_SLASH('\uF4FA'), USER_ASTRONAUT('\uF4FB'),
	USER_CHECK('\uF4FC'), USER_CIRCLE('\uF2BD'), USER_CLOCK('\uF4FD'),
	USER_COG('\uF4FE'), USER_EDIT('\uF4FF'), USER_FRIENDS('\uF500'),
	USER_GRADUATE('\uF501'), USER_LOCK('\uF502'), USER_MD('\uF0F0'),
	USER_MINUS('\uF503'), USER_NINJA('\uF504'), USER_PLUS('\uF234'),
	USER_SECRET('\uF21B'), USER_SHIELD('\uF505'), USER_SLASH('\uF506'),
	USER_TAG('\uF507'), USER_TIE('\uF508'), USER_TIMES('\uF235'),
	USERS('\uF0C0'), USERS_COG('\uF509'), UTENSIL_FORK('\uF2E3'),
	UTENSIL_KNIFE('\uF2E4'), UTENSIL_SPOON('\uF2E5'), UTENSILS('\uF2E7'),
	UTENSILS_ALT('\uF2E6'), VECTOR_SQUARE('\uF5CB'), VENUS('\uF221'),
	VENUS_DOUBLE('\uF226'), VENUS_MARS('\uF228'), VIAL('\uF492'),
	VIALS('\uF493'), VIDEO('\uF03D'), VIDEO_PLUS('\uF4E1'),
	VIDEO_SLASH('\uF4E2'), VOLLEYBALL_BALL('\uF45F'), VOLUME_DOWN('\uF027'),
	VOLUME_MUTE('\uF2E2'), VOLUME_OFF('\uF026'), VOLUME_UP('\uF028'),
	WALKING('\uF554'), WALLET('\uF555'), WAREHOUSE('\uF494'),
	WAREHOUSE_ALT('\uF495'), WATCH('\uF2E1'), WEIGHT('\uF496'),
	WEIGHT_HANGING('\uF5CD'), WHEELCHAIR('\uF193'), WHISTLE('\uF460'),
	WIFI('\uF1EB'), WINDOW('\uF40E'), WINDOW_ALT('\uF40F'),
	WINDOW_CLOSE('\uF410'), WINDOW_MAXIMIZE('\uF2D0'),
	WINDOW_MINIMIZE('\uF2D1'), WINDOW_RESTORE('\uF2D2'), WINE_GLASS('\uF4E3'),
	WINE_GLASS_ALT('\uF5CE'), WON_SIGN('\uF159'), WRENCH('\uF0AD'),
	X_RAY('\uF497'), YEN_SIGN('\uF157');

	private final char fontChar;

	/**
	 * Creates a new instance.
	 *
	 * @param fontChar The character code in the font awesome icon font.
	 */
	UiFontAwesomeIcon(char fontChar) {
		this.fontChar = fontChar;
	}

	/**
	 * Returns the character code of this instance in the font awesome icon
	 * font.
	 *
	 * @return The character code
	 */
	public final char getFontChar() {
		return fontChar;
	}

	/**
	 * Returns a new {@link UiIconName} initialized from this enumeration
	 * constant.
	 *
	 * @return The new icon
	 */
	@Override
	public UiIconName getIcon() {
		return new UiIconName(this);
	}
}
