//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// This file is a part of the 'esoco-business' project.
// Copyright 2019 Elmar Sonnenschein, esoco GmbH, Flensburg, Germany
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//	  http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
package de.esoco.process.ui.style;

/**
 * Contains default style name declaration for UI components.
 *
 * @author eso
 */
public class DefaultStyleNames {

	/**
	 * The brand label in a web app's top menu.
	 */
	public static final String TOP_MENU_BRAND_LABEL =
		"eb-top-menu-brand" + "-label";

	/**
	 * The copyright message in the page footer.
	 */
	public static final String FOOTER_COPYRIGHT = "eb-footer-copyright";

	/**
	 * Private, only static use.
	 */
	private DefaultStyleNames() {
	}
}
