//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// This file is a part of the 'esoco-common' project.
// Copyright 2020 Elmar Sonnenschein, esoco GmbH, Flensburg, Germany
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//	  http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
package de.esoco.lib.property;

/********************************************************************
 * Property interface for elements that implement a title attribute.
 *
 * @author eso
 */
public interface TitleAttribute {

	//~ Methods ----------------------------------------------------------------

	/***************************************
	 * Returns the element's title.
	 *
	 * @return The title string
	 */
	String getTitle();

	/***************************************
	 * Sets the element's title.
	 *
	 * @param sTitle The new title
	 */
	void setTitle(String sTitle);
}
