/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.app;

import de.esoco.lib.app.CommandLine;
import de.esoco.lib.app.CommandLineException;
import de.esoco.lib.logging.Log;
import de.esoco.lib.manage.Closeable;
import de.esoco.lib.manage.Disposable;
import de.esoco.lib.manage.RunCheck;
import de.esoco.lib.manage.Stoppable;
import de.esoco.lib.text.TextConvert;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.obrel.core.RelatedObject;

public abstract class Application
extends RelatedObject {
    private static final int CLEANUP_TOTAL_WAIT_TIME = 30000;
    private static final int CLEANUP_RESOURCE_WAIT_TIME = 10000;
    private static final int CLEANUP_SLEEP_TIME = 100;
    private final AtomicBoolean shutdownRequest = new AtomicBoolean(false);
    private CommandLine commandLine;
    private String appName = null;
    private List<Object> cleanupResources = null;
    private Thread mainThread;

    public final CommandLine getCommandLine() {
        return this.commandLine;
    }

    public void manageResource(Stoppable resource) {
        this.addManagedResource(resource);
    }

    public void manageResource(Closeable resource) {
        this.addManagedResource(resource);
    }

    public void manageResource(Disposable resource) {
        this.addManagedResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(String[] args) {
        block10: {
            if (this.appName == null) {
                try {
                    this.commandLine = this.processArguments(args);
                    if (this.commandLine.hasOption("h")) {
                        this.printHelp(this.commandLine.getOption("h"));
                        break block10;
                    }
                    if (this.commandLine.hasOption("-help")) {
                        this.printHelp(this.commandLine.getOption("-help"));
                        break block10;
                    }
                    String appName = ((Object)((Object)this)).getClass().getSimpleName();
                    Log.debugf("%s initializing...", appName);
                    this.initialize(this.commandLine);
                    Log.debugf("%s configuring...", appName);
                    this.configure(this.commandLine);
                    Log.debugf("%s starting...", appName);
                    this.startApp();
                    this.mainThread = Thread.currentThread();
                    Thread shutdownHook = new Thread(this::requestShutdown);
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                    try {
                        this.runApp();
                    }
                    finally {
                        if (!this.shutdownRequest.get()) {
                            Runtime.getRuntime().removeShutdownHook(shutdownHook);
                        }
                    }
                    this.stopApp();
                }
                catch (CommandLineException e) {
                    this.displayUsageError(e);
                }
                catch (Exception e) {
                    this.handleApplicationError(e);
                }
            }
        }
    }

    protected void addManagedResource(Object resource) {
        if (!(resource instanceof Stoppable || resource instanceof Closeable || resource instanceof Disposable)) {
            throw new IllegalArgumentException("No supported management interface implemented on " + resource);
        }
        if (this.cleanupResources == null) {
            this.cleanupResources = new ArrayList<Object>();
        }
        this.cleanupResources.add(resource);
    }

    protected void cleanup() throws Exception {
        if (this.cleanupResources != null) {
            int remainingWaitTime = 30000;
            for (int i = this.cleanupResources.size() - 1; i >= 0; --i) {
                Object resource = this.cleanupResources.get(i);
                if (resource instanceof Stoppable) {
                    Log.debug("Stopping " + resource);
                    ((Stoppable)resource).stop();
                }
                if (resource instanceof Closeable) {
                    Log.debug("Closing " + resource);
                    ((Closeable)resource).close();
                }
                if (resource instanceof Disposable) {
                    Log.debug("Disposing " + resource);
                    ((Disposable)resource).dispose();
                }
                if (!(resource instanceof RunCheck)) continue;
                int waitTime = remainingWaitTime > 10000 ? 10000 : remainingWaitTime;
                remainingWaitTime -= this.waitForResource((RunCheck)resource, waitTime, 100);
            }
        }
    }

    protected void configure(CommandLine commandLine) throws Exception {
    }

    protected void displayUsageError(CommandLineException e) {
        if (e != null) {
            System.err.printf("Error: %s\n", e.getMessage());
        }
        this.printHelp(System.out);
    }

    protected String getAppDescription() {
        return null;
    }

    protected Map<String, String> getCommandLineOptions() {
        return Collections.emptyMap();
    }

    protected String getNameOfAppBinary() {
        try {
            String appPath = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            this.appName = appPath.substring(appPath.lastIndexOf(47) + 1);
            int index = this.appName.indexOf(46);
            if (index > 0) {
                this.appName = this.appName.substring(0, index);
            }
            if (this.appName.length() == 0) {
                this.appName = ((Object)((Object)this)).getClass().getSimpleName();
            }
            return this.appName;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void handleApplicationError(Exception e) {
        Log.errorf(e, "Error executing %s", this.getNameOfAppBinary());
    }

    protected void initialize(CommandLine commandLine) throws Exception {
    }

    protected boolean isShutdownRequested() {
        return this.shutdownRequest.get();
    }

    protected void printHelp(Object command) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>(this.getCommandLineOptions());
        String helpInfo = "Display this help or help for a single option";
        options.put("h", helpInfo);
        options.put("-help", helpInfo);
        options.put("-args", "The name and path of a properties file to read the arguments from");
        if (command instanceof String) {
            String cmd = command.toString();
            System.out.printf("Option -%s: %s\n", command, options.get(cmd));
        } else {
            int maxCommandLength = 0;
            this.printUsage(System.out);
            for (String string : options.keySet()) {
                maxCommandLength = Math.max(string.length(), maxCommandLength);
            }
            for (Map.Entry entry : options.entrySet()) {
                String cmd = TextConvert.padRight((String)((String)entry.getKey()), (int)(maxCommandLength + 2), (char)' ');
                System.out.printf("\t-%s%s\n", cmd, entry.getValue());
            }
        }
    }

    protected void printUsage(PrintStream output) {
        String description = this.getAppDescription();
        output.printf("Usage: %s [options...]\n", this.getNameOfAppBinary());
        if (description != null) {
            output.println(description);
        }
    }

    protected CommandLine processArguments(String[] args) throws Exception {
        return new CommandLine(args, this.getCommandLineOptions());
    }

    protected void removeManagedResource(Object resource) {
        if (this.cleanupResources != null) {
            this.cleanupResources.remove(resource);
        }
    }

    protected void requestShutdown() {
        System.out.print("\nShutdown request received, terminating...\n");
        this.shutdownRequest.set(true);
        this.mainThread.interrupt();
        try {
            this.mainThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected abstract void runApp() throws Exception;

    protected void startApp() throws Exception {
    }

    protected void stopApp() throws Exception {
        String appName = ((Object)((Object)this)).getClass().getSimpleName();
        Log.debugf("%s cleanup...", appName);
        this.cleanup();
        Log.debugf("%s terminating...", appName);
        this.terminate();
        Log.debugf("%s stopped", appName);
    }

    protected void terminate() throws Exception {
    }

    protected int waitForResource(RunCheck resource, int maxWaitTime, int sleepTime) {
        int waitTime = 0;
        Log.debug("Waiting for " + resource);
        while (waitTime < maxWaitTime && resource.isRunning()) {
            try {
                Thread.sleep(sleepTime);
                waitTime += sleepTime;
            }
            catch (InterruptedException interruptedException) {}
        }
        return waitTime;
    }
}

