/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.app;

import de.esoco.lib.app.CommandLineException;
import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.text.TextUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandLine {
    public static final String EXTRA_ARGUMENTS = "__CMDLINE_EXTRA_ARGS";
    public static final String DEFAULT_OPTION_PATTERN = "(?i)-([\\w-_]+)(?:=(.+))?";
    private static final Set<String> STANDARD_OPTIONS = CollectionUtil.fixedSetOf((Object[])new String[]{"h", "-help"});
    private final Map<String, Object> commandLineOptions;
    private Map<String, String> allowedOptions = null;

    public CommandLine(InputStream argsStream) {
        this.commandLineOptions = CommandLine.readArguments(argsStream);
    }

    public CommandLine(String[] args) {
        this(args, null);
    }

    public CommandLine(String[] args, Map<String, String> allowedOptions) {
        this(args, Pattern.compile(DEFAULT_OPTION_PATTERN), allowedOptions);
    }

    public CommandLine(String[] args, Pattern argPattern, Map<String, String> allowedOptions) {
        this.allowedOptions = allowedOptions;
        this.commandLineOptions = this.parse(args, argPattern);
    }

    public static Pattern createPattern(String prefix, String assignment, String ... allowedOptions) {
        StringBuilder pattern = new StringBuilder(prefix + "(");
        StringBuilder valueOptions = new StringBuilder();
        for (String option : allowedOptions) {
            boolean valueRequired = option.endsWith(assignment);
            if (valueRequired) {
                int l = option.length() - assignment.length();
                valueOptions.append(option, 0, l).append('|');
                continue;
            }
            pattern.append(option).append('|');
        }
        if (pattern.charAt(pattern.length() - 1) == '|') {
            pattern.setLength(pattern.length() - 1);
            pattern.append(")(?:").append(assignment).append("(.+))?");
            if (valueOptions.length() > 0) {
                pattern.append("|(");
            }
        }
        if (valueOptions.length() > 0) {
            valueOptions.setLength(valueOptions.length() - 1);
            pattern.append((CharSequence)valueOptions).append(")");
            pattern.append(assignment).append("(.+)");
        }
        if (allowedOptions.length == 0) {
            pattern.append(")");
        }
        return Pattern.compile(pattern.toString());
    }

    public static Pattern createStandardPattern(String ... allowedOptions) {
        return CommandLine.createPattern("-", "=", allowedOptions);
    }

    public static Map<String, Object> readArguments(String fileName) {
        try {
            return CommandLine.readArguments(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Arguments file not found: " + fileName);
        }
    }

    public static Map<String, Object> readArguments(InputStream argsStream) {
        Properties properties = new Properties();
        try {
            properties.load(argsStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read arguments", e);
        }
        HashMap<String, Object> fileArguments = new HashMap<String, Object>(properties.size());
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            Object value = property.getValue();
            if ("true".equalsIgnoreCase(value.toString())) {
                value = Boolean.TRUE;
            } else if ("false".equalsIgnoreCase(value.toString())) {
                value = Boolean.FALSE;
            }
            fileArguments.put(property.getKey().toString(), value);
        }
        return fileArguments;
    }

    public List<String> getArguments() {
        return (List)this.commandLineOptions.get(EXTRA_ARGUMENTS);
    }

    public int getInt(String option) {
        String value = this.getString(option);
        try {
            return value != null ? Integer.parseInt(value) : -1;
        }
        catch (NumberFormatException e) {
            throw new CommandLineException("Integer value expected: %s", option, e);
        }
    }

    public Object getOption(String option) {
        return this.commandLineOptions.get(option);
    }

    public String getString(String option) {
        Object opt = this.getOption(option);
        return opt != null ? opt.toString() : null;
    }

    public boolean hasOption(String option) {
        return this.commandLineOptions.containsKey(option);
    }

    public Map<String, Object> parse(String[] args) {
        return this.parse(args, Pattern.compile(DEFAULT_OPTION_PATTERN));
    }

    public Map<String, Object> parse(String[] args, Pattern argPattern) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(args.length);
        ArrayList<String> extraArguments = new ArrayList<String>();
        String prevOption = null;
        for (String arg : args) {
            Matcher argMatcher = argPattern.matcher(arg);
            boolean isArg = argMatcher.matches();
            if (isArg) {
                if (argMatcher.groupCount() > 0) {
                    int group = TextUtil.nextGroup((Matcher)argMatcher, (int)1);
                    if (group == -1) {
                        throw new IllegalArgumentException("Invalid option: " + arg);
                    }
                    String option = argMatcher.group(group);
                    Object value = Boolean.TRUE;
                    if ((group = TextUtil.nextGroup((Matcher)argMatcher, (int)(group + 1))) != -1) {
                        value = TextUtil.parseObject((String)argMatcher.group(group));
                    }
                    if ((argPattern.flags() & 2) != 0) {
                        option = option.toLowerCase();
                    }
                    if (option.equals("-args")) {
                        if (value instanceof String) {
                            result.putAll(CommandLine.readArguments(value.toString()));
                            continue;
                        }
                        throw new CommandLineException("--args must point to an argument properties file", "--args");
                    }
                    if (this.allowedOptions != null && !STANDARD_OPTIONS.contains(option) && !this.allowedOptions.containsKey(option)) {
                        throw new CommandLineException("Unsupported option: " + arg, arg);
                    }
                    result.put(option, value);
                    prevOption = option;
                    continue;
                }
                throw new CommandLineException("Invalid option: " + arg, arg);
            }
            if (prevOption != null) {
                result.put(prevOption, TextUtil.parseObject((String)arg));
                prevOption = null;
                continue;
            }
            extraArguments.add(arg);
        }
        result.put(EXTRA_ARGUMENTS, extraArguments);
        return result;
    }

    public Object requireOption(String option) throws CommandLineException {
        return this.requireOption(option, null);
    }

    public Object requireOption(String option, Predicate<Object> isValidOption) throws CommandLineException {
        Object value = this.getOption(option);
        if (value != null) {
            if (isValidOption == null || isValidOption.test(value)) {
                return value;
            }
            throw new CommandLineException("Invalid command line option '%s'", option);
        }
        throw new CommandLineException("Missing command line option '%s'", option);
    }

    public String requireString(String option) throws CommandLineException {
        return this.requireOption(option).toString();
    }

    public String toString() {
        return "CommandLine[" + this.commandLineOptions + "]";
    }
}

