/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.app;

import de.esoco.lib.app.Application;
import de.esoco.lib.comm.CommunicationMethod;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.HttpEndpoint;
import de.esoco.lib.comm.Server;
import de.esoco.lib.comm.http.HttpRequestHandler;
import de.esoco.lib.comm.http.HttpStatusCode;
import de.esoco.lib.comm.http.HttpStatusException;
import de.esoco.lib.comm.http.ObjectSpaceHttpMethodHandler;
import de.esoco.lib.datatype.Pair;
import de.esoco.lib.expression.Function;
import de.esoco.lib.json.JsonBuilder;
import de.esoco.lib.logging.Log;
import de.esoco.lib.logging.LogLevel;
import de.esoco.lib.manage.Stoppable;
import de.esoco.lib.security.AuthenticationService;
import de.esoco.lib.security.SecurityRelationTypes;
import de.esoco.lib.text.TextUtil;
import java.util.Date;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.space.HtmlSpace;
import org.obrel.space.MappedSpace;
import org.obrel.space.ObjectSpace;
import org.obrel.space.RelationSpace;
import org.obrel.space.SynchronizedObjectSpace;
import org.obrel.type.StandardTypes;

public abstract class Service
extends Application
implements Stoppable {
    public static final String OPTION_NO_ENCRYPTION = "no-encryption";
    public static final RelationType<Boolean> RUN = RelationTypes.newFlagType((RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<String> LOG_LEVEL = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<ObjectSpace<String>> API = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<ObjectSpace<Object>> STATUS = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<ObjectSpace<Object>> CONTROL = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<HtmlSpace> WEBAPI = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<Boolean> PING = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<Boolean> HEALTHCHECK = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final CommunicationMethod<Void, String> CHECK_RUNNING = CommunicationMethod.doReceive(HttpEndpoint.httpGet("/api/control/run"));
    public static final CommunicationMethod<String, Void> REQUEST_STOP = CommunicationMethod.doSend(HttpEndpoint.httpPost("/api/control/run", "false"));
    public static final CommunicationMethod<String, Void> GET_LOG_LEVEL = CommunicationMethod.doSend(HttpEndpoint.httpGet("/api/control/log_level"));
    public static final CommunicationMethod<String, Void> SET_LOG_LEVEL = CommunicationMethod.doSend(HttpEndpoint.httpPost("/api/control/log_level", "ERROR"));
    private final boolean isRestService;
    private Thread restServerThread;
    private Server restServer;
    private ObjectSpace<Object> restServerSpace;
    private HttpRequestHandler.HttpRequestMethodHandler requestMethodHandler;

    public Service() {
        this(false);
    }

    protected Service(boolean isRestService) {
        this.isRestService = isRestService;
    }

    protected ObjectSpace<Object> buildApiSpace(ObjectSpace<Object> statusSpace, ObjectSpace<Object> controlSpace) {
        RelationSpace apiSpace = new RelationSpace(true);
        apiSpace.set(STATUS, statusSpace);
        apiSpace.set(CONTROL, controlSpace);
        return apiSpace;
    }

    protected ObjectSpace<Object> buildControlSpace(String serviceName) {
        RelationSpace controlSpace = new RelationSpace(true);
        controlSpace.set(StandardTypes.NAME, (Object)(serviceName + " Control"));
        controlSpace.set(RUN).onChange(run -> this.stopRequest(null));
        controlSpace.set(LOG_LEVEL, (Object)Log.getGlobalMinimumLogLevel().name()).onChange(this::setLogLevel);
        return controlSpace;
    }

    protected ObjectSpace<Object> buildRestServerSpace() {
        RelationSpace root = new RelationSpace(true);
        String serviceName = this.getServiceName();
        ObjectSpace<Object> statusSpace = this.buildStatusSpace(serviceName);
        SynchronizedObjectSpace controlSpace = this.buildControlSpace(serviceName);
        ObjectSpace<Object> apiSpace = this.buildApiSpace(statusSpace, (ObjectSpace<Object>)controlSpace);
        controlSpace = new SynchronizedObjectSpace(controlSpace);
        root.set(API, (Object)new MappedSpace(apiSpace, (Function)new ConvertApiValue()));
        root.set(WEBAPI, (Object)this.buildWebApiSpace(serviceName, apiSpace));
        root.set(PING);
        root.set(HEALTHCHECK);
        if (statusSpace != null) {
            statusSpace.set(StandardTypes.START_DATE, (Object)new Date()).viewAs(StandardTypes.INFO, (Relatable)root, this::getServiceInfo);
        }
        return root;
    }

    protected ObjectSpace<Object> buildStatusSpace(String serviceName) {
        RelationSpace statusSpace = new RelationSpace();
        statusSpace.set(StandardTypes.NAME, (Object)(serviceName + " Status"));
        statusSpace.init(StandardTypes.UPTIME);
        return statusSpace;
    }

    protected HtmlSpace buildWebApiSpace(String serviceName, ObjectSpace<Object> apiSpace) {
        return new HtmlSpace(apiSpace, "webapi").with(StandardTypes.NAME, (Object)serviceName);
    }

    protected Server.RequestHandler createRequestHandler(Relatable context) {
        HttpRequestHandler requestHandler = new HttpRequestHandler(context, this.getRequestMethodHandler());
        return requestHandler;
    }

    protected HttpRequestHandler.HttpRequestMethodHandler createRequestMethodHandler() {
        return new ObjectSpaceHttpMethodHandler(this.restServerSpace, "info");
    }

    protected Server createRestServer() {
        Server.RequestHandlerFactory requestHandlerFactory = this.getRestRequestHandlerFactory();
        Server server = (Server)((Server)new Server(requestHandlerFactory).with(StandardTypes.NAME, this.getServiceName())).with(StandardTypes.PORT, this.getRestServerPort());
        if (!this.getCommandLine().hasOption(OPTION_NO_ENCRYPTION)) {
            server.set(CommunicationRelationTypes.ENCRYPTION);
            if (this instanceof AuthenticationService) {
                server.set(SecurityRelationTypes.AUTHENTICATION_SERVICE, (AuthenticationService)((Object)this));
            }
        }
        return server;
    }

    protected HttpRequestHandler.HttpRequestMethodHandler getRequestMethodHandler() {
        if (this.requestMethodHandler == null) {
            this.requestMethodHandler = this.createRequestMethodHandler();
        }
        return this.requestMethodHandler;
    }

    protected Server.RequestHandlerFactory getRestRequestHandlerFactory() {
        return context -> this.createRequestHandler(context);
    }

    protected int getRestServerPort() {
        Object port = this.getCommandLine().requireOption("port");
        if (port instanceof Number) {
            return ((Number)port).intValue();
        }
        throw new IllegalArgumentException("Invalid REST server port: " + port);
    }

    protected final ObjectSpace<Object> getRestSpace() {
        return this.restServerSpace;
    }

    protected String getServiceInfo(Date startDate) {
        return String.format("%1$s service, running since %2$tF %2$tT [Uptime: %3$s]", this.getServiceName(), startDate, TextUtil.formatLongDuration((long)(System.currentTimeMillis() - startDate.getTime()), (boolean)false));
    }

    protected String getServiceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected void handleApplicationError(Exception e) {
        if (this.restServer != null) {
            this.restServer.stop();
        }
        super.handleApplicationError(e);
    }

    @Override
    protected final void runApp() throws Exception {
        this.restServerSpace = this.buildRestServerSpace();
        this.restServer = this.startRestServer();
        this.runService();
        if (this.isRestService) {
            this.restServerThread.join();
        } else {
            this.restServer.stop();
        }
    }

    protected abstract void runService() throws Exception;

    protected <T> void setStatus(RelationType<T> type, T value) {
        ((ObjectSpace)this.restServerSpace.get(STATUS)).set(type, value);
    }

    protected Server startRestServer() throws Exception {
        Server server = this.createRestServer();
        this.manageResource(server);
        this.restServerThread = new Thread(server);
        this.restServerThread.setUncaughtExceptionHandler((t, e) -> this.stopRequest(e));
        this.restServerThread.start();
        Log.infof("%s running, listening on %sport %d", this.getServiceName(), (Boolean)server.get(CommunicationRelationTypes.ENCRYPTION) != false ? "TLS " : "", this.getRestServerPort());
        return server;
    }

    private void setLogLevel(String level) {
        try {
            Log.setGlobalMinimumLogLevel(LogLevel.valueOf(level.toUpperCase()));
        }
        catch (Exception e) {
            throw new HttpStatusException(HttpStatusCode.BAD_REQUEST, "Undefined log level: " + level, new Pair[0]);
        }
    }

    private void stopRequest(Throwable e) {
        if (e != null) {
            Log.errorf(e, "%s error, shutting down", this.isRestService ? "Server" : "Control server");
        } else {
            Log.infof("Stop requested, shutting down", new Object[0]);
        }
        this.restServer.stop();
        this.stop();
    }

    static {
        RelationTypes.init((Class[])new Class[]{Service.class});
    }

    protected static class ConvertApiValue
    extends JsonBuilder.ConvertJson {
        protected ConvertApiValue() {
        }

        public String evaluate(Object value) {
            if (value instanceof ObjectSpace) {
                throw new IllegalArgumentException("Not an API endpoint");
            }
            return super.evaluate(value);
        }
    }
}

