/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.collection;

import de.esoco.lib.collection.CollectionEvent;
import de.esoco.lib.event.ElementEvent;
import de.esoco.lib.event.EventHandler;
import de.esoco.lib.event.EventSource;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractObservableCollection<T, C extends Collection<T>, E extends CollectionEvent<T, C>>
extends AbstractCollection<T>
implements EventSource<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final C observedCollection;
    private List<EventHandler<? super E>> listeners;

    public AbstractObservableCollection(C observedCollection) {
        this.observedCollection = observedCollection;
    }

    @Override
    public boolean add(T element) {
        this.notifyListeners(ElementEvent.EventType.ADD, element, null, -1);
        return this.observedCollection.add(element);
    }

    public void addListener(EventHandler<? super E> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EventHandler<? super E>>(1);
        }
        this.listeners.add(listener);
    }

    @Override
    public void clear() {
        this.notifyListeners(ElementEvent.EventType.REMOVE_ALL, null, null, -1);
        this.observedCollection.clear();
    }

    public Class<? super E> getEventClass() {
        return CollectionEvent.class;
    }

    public boolean hasListeners() {
        return this.listeners != null;
    }

    @Override
    public Iterator<T> iterator() {
        return new ObservableCollectionIterator(this, this.observedCollection.iterator());
    }

    public void removeListener(EventHandler<? super E> listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    @Override
    public int size() {
        return this.observedCollection.size();
    }

    protected abstract E createEvent(ElementEvent.EventType var1, T var2, T var3, int var4);

    protected final C getObservedCollection() {
        return this.observedCollection;
    }

    protected void notifyListeners(ElementEvent.EventType type, T element, T updateValue, int index) {
        if (this.hasListeners()) {
            E event = this.createEvent(type, element, updateValue, index);
            for (EventHandler<? super E> eventHandler : this.listeners) {
                eventHandler.handleEvent(event);
            }
        }
    }

    static class ObservableCollectionIterator<I extends Iterator<T>>
    implements Iterator<T> {
        private final I iterator;
        private T current;
        final /* synthetic */ AbstractObservableCollection this$0;

        ObservableCollectionIterator(I iterator) {
            this.this$0 = this$0;
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.setCurrentElement(this.iterator.next());
            return this.current;
        }

        @Override
        public void remove() {
            this.this$0.notifyListeners(ElementEvent.EventType.REMOVE, this.current, null, -1);
            this.setCurrentElement(null);
            this.iterator.remove();
        }

        final T getCurrentElement() {
            return this.current;
        }

        final I getIterator() {
            return this.iterator;
        }

        void setCurrentElement(T element) {
            this.current = element;
        }
    }
}

