/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.collection;

import de.esoco.lib.expression.Predicates;
import de.esoco.lib.json.Json;
import de.esoco.lib.json.JsonBuilder;
import de.esoco.lib.json.JsonSerializable;
import de.esoco.lib.text.TextConvert;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.function.Predicate;

public class ByteArray
implements JsonSerializable<ByteArray> {
    public static final int DEFAULT_CAPACITY = 10;
    private byte[] data;
    private int size = 0;
    private int capacityIncrement = 10;

    public ByteArray() {
        this(10);
    }

    public ByteArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid capacity: " + capacity);
        }
        this.data = new byte[capacity];
        this.capacityIncrement = capacity > 0 ? capacity : 10;
    }

    public ByteArray(byte[] data) {
        int l = data.length;
        data = new byte[l];
        System.arraycopy(data, 0, data, 0, l);
    }

    public static ByteArray valueOf(String hexValue) {
        return new ByteArray(TextConvert.toBytes((String)hexValue));
    }

    public void add(byte value) {
        this.checkCapacity(1);
        this.data[this.size++] = value;
    }

    public void add(byte[] values) {
        this.add(values, 0, values.length);
    }

    public void add(byte[] values, int offset, int count) {
        this.checkCapacity(count);
        System.arraycopy(values, 0, this.data, this.size, count);
        this.size += count;
    }

    public void appendTo(JsonBuilder builder) {
        builder.appendString("0x" + this);
    }

    public void clear() {
        this.size = 0;
    }

    public byte[] copyTo(byte[] target, int offset) {
        System.arraycopy(this.data, 0, target, offset, this.size);
        return target;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.data.length) {
            this.setCapacity(minCapacity);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ByteArray other = (ByteArray)object;
        if (this.size != other.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }

    public ByteArray fromJson(String json) {
        String parsed = (String)Json.parse((String)json, String.class);
        if (!parsed.startsWith("0x")) {
            throw new IllegalArgumentException("Missing 0x prefix: " + this.data);
        }
        if (parsed.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid byte array data: " + parsed);
        }
        parsed = parsed.substring(2);
        int chars = parsed.length();
        this.clear();
        this.ensureCapacity(chars / 2);
        for (int i = 0; i < chars; i += 2) {
            this.data[this.size++] = (byte)Short.parseShort(parsed.substring(i, i + 2), 16);
        }
        return this;
    }

    public byte get(int index) {
        this.checkIndex(index);
        return this.data[index];
    }

    public int getCapacity() {
        return this.data.length;
    }

    public int getCapacityIncrement() {
        return this.capacityIncrement;
    }

    public int getSize() {
        return this.size;
    }

    public int hashCode() {
        int hash = this.size;
        for (int i = 0; i < this.size; ++i) {
            hash = 31 * hash + this.data[i];
        }
        return hash;
    }

    public int indexOf(byte value, int pos) {
        while (pos < this.size && value != this.data[pos]) {
            ++pos;
        }
        return pos < this.size ? pos : -1;
    }

    public void insert(byte value, int index) {
        this.checkIndex(index);
        this.checkCapacity(1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = value;
        ++this.size;
    }

    public int insertAscending(byte value, int start) {
        int pos;
        this.checkCapacity(1);
        for (pos = start; pos < this.size && value >= this.data[pos]; ++pos) {
        }
        for (int i = this.size; i > pos; --i) {
            this.data[i] = this.data[i - 1];
        }
        this.data[pos] = value;
        ++this.size;
        return pos;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public byte last() {
        return this.data[this.size - 1];
    }

    public ByteArray map(Predicate<Byte> include, Function<Byte, Byte> map) {
        ByteArray result = new ByteArray(this.size);
        for (int i = 0; i < this.size; ++i) {
            byte value = this.data[i];
            if (!include.test(value)) continue;
            result.add(map.apply(value));
        }
        return result;
    }

    public byte pop() {
        if (this.size > 0) {
            return this.data[--this.size];
        }
        throw new ArrayIndexOutOfBoundsException("ByteArray.pop(): array is empty");
    }

    public void push(byte value) {
        this.add(value);
    }

    public void remove(int index) {
        this.checkIndex(index);
        --this.size;
        System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
    }

    public ByteArray replaceAll(byte value, byte replacement) {
        return this.map((Predicate<Byte>)Predicates.alwaysTrue(), b -> b == value ? replacement : value);
    }

    public void set(byte value, int index) {
        this.checkIndex(index);
        this.data[index] = value;
    }

    public void setCapacityIncrement(int increment) {
        this.capacityIncrement = increment;
    }

    public void setSize(int newSize) {
        this.ensureCapacity(newSize);
        this.size = newSize;
    }

    public String toAscii() {
        return this.toText(StandardCharsets.US_ASCII);
    }

    public byte[] toByteArray() {
        return this.copyTo(new byte[this.size], 0);
    }

    public String toString() {
        return TextConvert.hexString((byte[])this.data, (int)0, (int)this.size, (String)"");
    }

    public String toText(Charset charset) {
        return new String(this.data, charset);
    }

    public String toUtf8() {
        return this.toText(StandardCharsets.UTF_8);
    }

    public void trimToSize() {
        if (this.size < this.data.length) {
            this.setCapacity(this.size);
        }
    }

    protected final void checkCapacity(int increment) {
        int newSize = this.size + increment;
        if (newSize > this.data.length) {
            newSize = (newSize / this.capacityIncrement + 1) * this.capacityIncrement;
            this.setCapacity(newSize);
        }
    }

    protected final void checkIndex(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Illegal index: " + index);
        }
    }

    protected final void setCapacity(int newCapacity) {
        byte[] newData = new byte[newCapacity];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }
}

