/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.collection;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CacheMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private int capacity;

    public CacheMap(int capacity) {
        super(capacity, 0.75f, true);
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Map.Entry<K, V> removeEldest() {
        Iterator iterator = this.entrySet().iterator();
        Map.Entry eldest = null;
        if (iterator.hasNext()) {
            eldest = iterator.next();
            iterator.remove();
        }
        return eldest;
    }

    public void setCapacity(int newCapacity) {
        while (this.size() > newCapacity) {
            this.removeEldest();
        }
        this.capacity = newCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.capacity;
    }
}

