/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.collection;

import de.esoco.lib.expression.Predicates;
import java.util.function.Function;
import java.util.function.Predicate;

public class IntArray {
    public static final int DEFAULT_CAPACITY = 10;
    private int[] data;
    private int size = 0;
    private int capacityIncrement;

    public IntArray() {
        this(10);
    }

    public IntArray(int[] data) {
        int l = data.length;
        data = new int[l];
        System.arraycopy(data, 0, data, 0, this.last());
    }

    public IntArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid capacity: " + capacity);
        }
        this.data = new int[capacity];
        this.capacityIncrement = capacity > 0 ? capacity : 10;
    }

    public void add(int value) {
        this.checkCapacity(1);
        this.data[this.size++] = value;
    }

    public void clear() {
        this.size = 0;
    }

    public void copyTo(int[] dst, int offset) {
        System.arraycopy(this.data, 0, dst, offset, this.size);
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.data.length) {
            this.setCapacity(minCapacity);
        }
    }

    public int get(int index) {
        this.checkIndex(index);
        return this.data[index];
    }

    public int getCapacity() {
        return this.data.length;
    }

    public int getCapacityIncrement() {
        return this.capacityIncrement;
    }

    public int getSize() {
        return this.size;
    }

    public int indexOf(int value, int pos) {
        while (pos < this.size && value != this.data[pos]) {
            ++pos;
        }
        return pos < this.size ? pos : -1;
    }

    public void insert(int value, int index) {
        this.checkIndex(index);
        this.checkCapacity(1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = value;
        ++this.size;
    }

    public int insertAscending(int value, int start) {
        int pos;
        this.checkCapacity(1);
        for (pos = start; pos < this.size && value >= this.data[pos]; ++pos) {
        }
        for (int i = this.size; i > pos; --i) {
            this.data[i] = this.data[i - 1];
        }
        this.data[pos] = value;
        ++this.size;
        return pos;
    }

    public int last() {
        return this.data[this.size - 1];
    }

    public IntArray map(Predicate<Integer> include, Function<Integer, Integer> map) {
        IntArray result = new IntArray(this.size);
        for (int i = 0; i < this.size; ++i) {
            int value = this.data[i];
            if (!include.test(value)) continue;
            result.add(value);
        }
        return result;
    }

    public int pop() {
        if (this.size > 0) {
            return this.data[--this.size];
        }
        throw new ArrayIndexOutOfBoundsException("IntArray.pop(): array is empty");
    }

    public void push(int value) {
        this.add(value);
    }

    public void remove(int index) {
        this.checkIndex(index);
        --this.size;
        System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
    }

    public IntArray replaceAll(int value, int replacement) {
        return this.map((Predicate<Integer>)Predicates.alwaysTrue(), b -> b == value ? replacement : value);
    }

    public void set(int value, int index) {
        this.checkIndex(index);
        this.data[index] = value;
    }

    public void setCapacityIncrement(int increment) {
        this.capacityIncrement = increment;
    }

    public void setSize(int newSize) {
        this.ensureCapacity(newSize);
        this.size = newSize;
    }

    public int[] toIntArray() {
        int[] result = new int[this.size];
        this.copyTo(result, 0);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("IntArray[");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.data[i]);
        }
        result.append("]");
        return result.toString();
    }

    public void trimToSize() {
        if (this.size < this.data.length) {
            this.setCapacity(this.size);
        }
    }

    protected final void checkCapacity(int increment) {
        int newSize = this.size + increment;
        if (newSize > this.data.length) {
            if (increment <= 2) {
                newSize += 10 - increment;
            }
            this.setCapacity(newSize);
        }
    }

    protected final void checkIndex(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Illegal index: " + index);
        }
    }

    protected final void setCapacity(int newCapacity) {
        int[] newData = new int[newCapacity];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }
}

