/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.collection;

import de.esoco.lib.collection.AbstractObservableCollection;
import de.esoco.lib.collection.ListEvent;
import de.esoco.lib.event.ElementEvent;
import de.esoco.lib.event.EventSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class ObservableList<E>
extends AbstractObservableCollection<E, List<E>, ListEvent<E>>
implements List<E>,
EventSource<ListEvent<E>>,
Serializable,
RandomAccess {
    private static final long serialVersionUID = 1L;

    public ObservableList() {
        this(new ArrayList());
    }

    public ObservableList(List<E> observedList) {
        super(observedList);
    }

    @Override
    public boolean add(E element) {
        this.add(this.size(), element);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.notifyListeners(ElementEvent.EventType.ADD, element, null, index);
        ((List)this.getObservedCollection()).add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        for (E object : collection) {
            this.add(index++, object);
        }
        return !collection.isEmpty();
    }

    @Override
    public E get(int index) {
        return ((List)this.getObservedCollection()).get(index);
    }

    @Override
    public Class<? super ListEvent<E>> getEventClass() {
        return ListEvent.class;
    }

    @Override
    public int indexOf(Object object) {
        return ((List)this.getObservedCollection()).indexOf(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return ((List)this.getObservedCollection()).lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ObservableListIterator(((List)this.getObservedCollection()).listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ObservableListIterator(((List)this.getObservedCollection()).listIterator(index));
    }

    @Override
    public E remove(int index) {
        this.notifyListeners(ElementEvent.EventType.REMOVE, this.get(index), null, index);
        return ((List)this.getObservedCollection()).remove(index);
    }

    @Override
    public E set(int index, E element) {
        this.notifyListeners(ElementEvent.EventType.UPDATE, this.get(index), element, index);
        return ((List)this.getObservedCollection()).set(index, element);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List subList = ((List)this.getObservedCollection()).subList(fromIndex, toIndex);
        return new ObservableSubList(subList, fromIndex);
    }

    @Override
    protected ListEvent<E> createEvent(ElementEvent.EventType type, E element, E updateValue, int index) {
        return new ListEvent<E>(type, this, element, updateValue, index);
    }

    class ObservableListIterator
    extends AbstractObservableCollection.ObservableCollectionIterator<ListIterator<E>>
    implements ListIterator<E> {
        boolean forward;
        private int current;

        ObservableListIterator(ListIterator<E> iterator) {
            super((AbstractObservableCollection)ObservableList.this, iterator);
            this.forward = true;
            this.current = -1;
        }

        @Override
        public void add(E object) {
            ObservableList.this.notifyListeners(ElementEvent.EventType.ADD, object, null, this.forward ? this.current + 1 : this.current);
            ((ListIterator)this.getIterator()).add(object);
            ++this.current;
        }

        @Override
        public boolean hasPrevious() {
            return ((ListIterator)this.getIterator()).hasPrevious();
        }

        @Override
        public E next() {
            Object next = super.next();
            if (this.forward) {
                ++this.current;
            } else {
                this.forward = true;
            }
            return next;
        }

        @Override
        public int nextIndex() {
            return ((ListIterator)this.getIterator()).nextIndex();
        }

        @Override
        public E previous() {
            Object previous = ((ListIterator)this.getIterator()).previous();
            this.setCurrentElement(previous);
            if (this.forward) {
                this.forward = false;
            } else {
                --this.current;
            }
            return previous;
        }

        @Override
        public int previousIndex() {
            return ((ListIterator)this.getIterator()).previousIndex();
        }

        @Override
        public void remove() {
            ObservableList.this.notifyListeners(ElementEvent.EventType.REMOVE, this.getCurrentElement(), null, this.current);
            ((ListIterator)this.getIterator()).remove();
            if (this.forward) {
                --this.current;
            }
        }

        @Override
        public void set(E object) {
            ObservableList.this.notifyListeners(ElementEvent.EventType.UPDATE, this.getCurrentElement(), object, this.current);
            ((ListIterator)this.getIterator()).set(object);
            this.setCurrentElement(object);
        }
    }

    class ObservableSubList
    extends ObservableList<E> {
        private static final long serialVersionUID = 1L;
        private final int start;

        public ObservableSubList(List<E> subList, int start) {
            super(subList);
            this.start = start;
        }

        @Override
        protected void notifyListeners(ElementEvent.EventType type, E element, E updateValue, int index) {
            super.notifyListeners(type, element, updateValue, index);
            ObservableList.this.notifyListeners(type, element, updateValue, index + this.start);
        }
    }
}

