/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.collection;

import de.esoco.lib.collection.AbstractObservableCollection;
import de.esoco.lib.collection.MapEvent;
import de.esoco.lib.collection.ObservableSet;
import de.esoco.lib.event.ElementEvent;
import de.esoco.lib.event.EventHandler;
import de.esoco.lib.event.EventSource;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObservableMap<K, V>
extends AbstractMap<K, V>
implements EventSource<MapEvent<K, V>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> observedMap;
    private List<EventHandler<? super MapEvent<K, V>>> listeners;

    public ObservableMap() {
        this(new HashMap());
    }

    public ObservableMap(Map<K, V> observedMap) {
        this.observedMap = observedMap;
    }

    public void addListener(EventHandler<? super MapEvent<K, V>> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EventHandler<? super MapEvent<K, V>>>(1);
        }
        this.listeners.add(listener);
    }

    @Override
    public void clear() {
        this.notifyListeners(ElementEvent.EventType.REMOVE_ALL, null, null);
        this.observedMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ObservableEntrySet(this.observedMap.entrySet());
    }

    public Class<? super MapEvent<K, V>> getEventClass() {
        return MapEvent.class;
    }

    public boolean hasListeners() {
        return this.listeners != null;
    }

    @Override
    public V put(K key, V value) {
        this.notifyListeners(this.observedMap.containsKey(key) ? ElementEvent.EventType.UPDATE : ElementEvent.EventType.ADD, key, value);
        return this.observedMap.put(key, value);
    }

    public void removeListener(EventHandler<? super MapEvent<K, V>> listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    protected void notifyListeners(ElementEvent.EventType eventType, K element, V updateValue) {
        if (this.listeners != null) {
            MapEvent<K, V> event = new MapEvent<K, V>(eventType, this, element, updateValue);
            for (EventHandler<? super MapEvent<K, V>> eventHandler : this.listeners) {
                eventHandler.handleEvent(event);
            }
        }
    }

    class ObservableEntrySet
    extends ObservableSet<Map.Entry<K, V>> {
        private static final long serialVersionUID = 1L;

        public ObservableEntrySet(Set<Map.Entry<K, V>> entrySet) {
            super(entrySet);
        }

        @Override
        public boolean add(Map.Entry<K, V> element) {
            throw new UnsupportedOperationException("Use Map.put() to add map entries");
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ObservableEntrySetIterator(((Set)this.getObservedCollection()).iterator());
        }

        class ObservableEntrySetIterator
        extends AbstractObservableCollection.ObservableCollectionIterator<Iterator<Map.Entry<K, V>>> {
            ObservableEntrySetIterator(Iterator<Map.Entry<K, V>> iterator) {
                super((AbstractObservableCollection)ObservableEntrySet.this, iterator);
            }

            @Override
            public void remove() {
                Map.Entry current = (Map.Entry)this.getCurrentElement();
                Object key = current.getKey();
                Object value = current.getValue();
                ObservableMap.this.notifyListeners(ElementEvent.EventType.REMOVE, key, value);
                this.getIterator().remove();
                this.setCurrentElement(null);
            }

            @Override
            void setCurrentElement(Map.Entry<K, V> element) {
                super.setCurrentElement(new ObservableEntry(element));
            }
        }
    }

    class ObservableEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> observedEntry;

        public ObservableEntry(Map.Entry<K, V> observedEntry) {
            this.observedEntry = observedEntry;
        }

        @Override
        public boolean equals(Object object) {
            return this.observedEntry.equals(object);
        }

        @Override
        public K getKey() {
            return this.observedEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.observedEntry.getValue();
        }

        @Override
        public int hashCode() {
            return this.observedEntry.hashCode();
        }

        @Override
        public V setValue(V newValue) {
            ObservableMap.this.notifyListeners(ElementEvent.EventType.UPDATE, this.observedEntry.getKey(), newValue);
            return this.observedEntry.setValue(newValue);
        }

        public String toString() {
            return this.observedEntry.toString();
        }
    }
}

