/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.collection;

import de.esoco.lib.collection.CacheMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class ReferenceCacheMap<K, V>
extends CacheMap<K, MappedReference<K, V>> {
    private static final long serialVersionUID = 1L;
    private final ReferenceQueue<V> queue = new ReferenceQueue();
    private final boolean softReferences;

    public ReferenceCacheMap(int capacity, boolean soft) {
        super(capacity);
        this.softReferences = soft;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        super.clear();
    }

    @Override
    public MappedReference<K, V> get(Object key) {
        this.cleanup();
        return (MappedReference)super.get(key);
    }

    public V getValue(Object key) {
        Object reference = this.get(key);
        return reference != null ? (V)reference.get() : null;
    }

    @Override
    public MappedReference<K, V> put(K key, MappedReference<K, V> reference) {
        throw new UnsupportedOperationException("Use putValue(key, value) instead");
    }

    public void putValue(K key, V value) {
        this.cleanup();
        Reference ref = this.softReferences ? new MappedSoftReference<K, V>(key, value, this.queue) : new MappedWeakReference<K, V>(key, value, this.queue);
        super.put(key, ref);
    }

    @Override
    public MappedReference<K, V> remove(Object key) {
        this.cleanup();
        return (MappedReference)super.remove(key);
    }

    @Override
    public int size() {
        this.cleanup();
        return super.size();
    }

    private void cleanup() {
        MappedReference reference;
        while ((reference = (MappedReference)((Object)this.queue.poll())) != null) {
            super.remove(reference.getKey());
        }
    }

    public static interface MappedReference<K, V> {
        public V get();

        public K getKey();
    }

    public static class MappedSoftReference<K, V>
    extends SoftReference<V>
    implements MappedReference<K, V> {
        private final K key;

        public MappedSoftReference(K key, V referencedValue, ReferenceQueue<V> queue) {
            super(referencedValue, queue);
            this.key = key;
        }

        @Override
        public final K getKey() {
            return this.key;
        }
    }

    public static class MappedWeakReference<K, V>
    extends WeakReference<V>
    implements MappedReference<K, V> {
        private final K key;

        public MappedWeakReference(K key, V referencedValue, ReferenceQueue<V> queue) {
            super(referencedValue, queue);
            this.key = key;
        }

        @Override
        public final K getKey() {
            return this.key;
        }
    }
}

