/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.comm.CommunicationMethod;
import de.esoco.lib.comm.Connection;
import de.esoco.lib.expression.Function;

public class CommunicationChain<I, V, O>
extends CommunicationMethod<I, O> {
    private final CommunicationMethod<I, V> communicationMethod;
    private final Function<? super V, O> processValue;

    CommunicationChain(CommunicationMethod<I, V> communicationMethod, Function<? super V, O> processValue) {
        super(processValue.getToken() + "(" + communicationMethod.getToken() + ")", null);
        this.communicationMethod = communicationMethod;
        this.processValue = processValue;
    }

    @Override
    public O doOn(Connection connection, I input) {
        V value = this.communicationMethod.evaluate(input, connection);
        return (O)this.processValue.evaluate(value);
    }

    public final CommunicationMethod<I, V> getCommunicationMethod() {
        return this.communicationMethod;
    }

    public final Function<? super V, O> getValueFunction() {
        return this.processValue;
    }
}

