/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.datatype.Pair;
import de.esoco.lib.expression.Function;
import de.esoco.lib.net.NetUtil;
import java.util.Map;

public class CommunicationFunctions {
    private static final String URL_INPUT_PARAM = "!_INPUT_!";

    private CommunicationFunctions() {
    }

    @SafeVarargs
    public static Function<String, String> encodeUrlParameters(String inputParam, Pair<String, String> ... params) {
        return CommunicationFunctions.encodeUrlParameters(inputParam, CollectionUtil.orderedMapOf(params));
    }

    public static Function<String, String> encodeUrlParameters(String inputParam, Map<String, String> params) {
        String encodedParams = NetUtil.encodeUrlParameters(params);
        if (inputParam != null) {
            encodedParams = String.format("%s=%s&%s", NetUtil.encodeUrlElement(inputParam), URL_INPUT_PARAM, encodedParams);
        }
        String urlParams = encodedParams;
        return paramValue -> urlParams.replace(URL_INPUT_PARAM, NetUtil.encodeUrlElement(paramValue));
    }
}

