/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.comm.CommunicationChain;
import de.esoco.lib.comm.CommunicationException;
import de.esoco.lib.comm.Connection;
import de.esoco.lib.comm.Endpoint;
import de.esoco.lib.comm.EndpointFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.logging.Log;
import de.esoco.lib.logging.LogExtent;

public abstract class CommunicationMethod<I, O>
extends AbstractBinaryFunction<I, Connection, O> {
    private final I defaultInput;

    public CommunicationMethod(String methodName, I defaultInput) {
        super(null, methodName);
        this.defaultInput = defaultInput;
    }

    public static <T> CommunicationMethod<Void, T> doReceive(final CommunicationMethod<?, T> request) {
        return new CommunicationMethod<Void, T>(request.getToken(), null){

            @Override
            public T doOn(Connection connection, Void input) {
                return request.evaluate(null, connection);
            }
        };
    }

    public static <T> CommunicationMethod<T, Void> doSend(final CommunicationMethod<T, ?> request) {
        return new CommunicationMethod<T, Void>(request.getToken(), null){

            @Override
            public Void doOn(Connection connection, T input) {
                request.evaluate(input, connection);
                return null;
            }
        };
    }

    public abstract O doOn(Connection var1, I var2) throws Exception;

    public final O evaluate(I input, Connection connection) {
        LogExtent logExtent = (LogExtent)((Object)connection.get(Log.LOG_EXTENT));
        try {
            if (input == null) {
                input = this.defaultInput;
            }
            O result = this.doOn(connection, input);
            if (logExtent.logs(LogExtent.SUCCESS)) {
                Log.info(this.getLogMessage(connection, input, null));
            }
            return result;
        }
        catch (Exception e) {
            if (logExtent.logs(LogExtent.ERRORS)) {
                Log.error(this.getLogMessage(connection, input, e), e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CommunicationException(e);
        }
    }

    public EndpointFunction<I, O> from(Endpoint endpoint) {
        return endpoint.then(this);
    }

    public final I getDefaultInput() {
        return this.defaultInput;
    }

    public O getFrom(Connection connection, I input) {
        return this.evaluate(input, connection);
    }

    public EndpointFunction<I, O> on(Endpoint endpoint) {
        return this.from(endpoint);
    }

    public O sendTo(Connection connection, I input) {
        return this.evaluate(input, connection);
    }

    public <T> CommunicationMethod<I, T> then(Function<? super O, T> other) {
        return new CommunicationChain(this, other);
    }

    protected String getLogMessage(Connection connection, I input, Exception exception) {
        String methodDescription = this.getMethodDescription(connection, input);
        String message = exception != null ? String.format("Failure: %s [%s]", methodDescription, exception.getMessage()) : String.format("Success: %s", methodDescription);
        return message;
    }

    protected String getMethodDescription(Connection connection, I input) {
        return String.format("%s(%s)", this.getToken(), input);
    }
}

