/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.comm.CommunicationException;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Endpoint;
import de.esoco.lib.manage.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import org.obrel.core.RelatedObject;
import org.obrel.type.MetaTypes;

public class Connection
extends RelatedObject
implements Closeable {
    private final Endpoint endpoint;

    Connection(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void close() {
        try {
            this.endpoint.closeConnection(this);
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw (CommunicationException)e;
            }
            throw new CommunicationException(e);
        }
        this.set(MetaTypes.CLOSED);
    }

    public final Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getPassword() {
        return (String)this.get(CommunicationRelationTypes.PASSWORD);
    }

    public URI getUri() {
        try {
            return new URI((String)this.getEndpoint().get(CommunicationRelationTypes.ENDPOINT_ADDRESS));
        }
        catch (URISyntaxException e) {
            throw new CommunicationException(e);
        }
    }

    public String getUserName() {
        return (String)this.get(CommunicationRelationTypes.USER_NAME);
    }
}

