/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.comm.CommunicationException;
import de.esoco.lib.comm.CommunicationMethod;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Connection;
import de.esoco.lib.comm.EndpointFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.logging.Log;
import de.esoco.lib.logging.LogExtent;
import de.esoco.lib.text.TextConvert;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.obrel.core.FluentRelatable;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Params;
import org.obrel.core.ProvidesConfiguration;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public abstract class Endpoint
extends RelatedObject
implements Function<Relatable, Connection>,
FluentRelatable<Endpoint> {
    protected static final RelationType<String> ENDPOINT_SCHEME = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    protected static final RelationType<Connection> ENDPOINT_CONNECTION = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[]{RelationTypeModifier.PRIVATE});
    protected static final RelationType<OutputStream> ENDPOINT_OUTPUT_STREAM = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[]{RelationTypeModifier.PRIVATE});
    protected static final RelationType<InputStream> ENDPOINT_INPUT_STREAM = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[]{RelationTypeModifier.PRIVATE});
    private static final Map<String, Class<? extends Endpoint>> endpointRegistry = new HashMap<String, Class<? extends Endpoint>>();
    private static final Relatable defaultParams = new Params();
    private static ProvidesConfiguration globalConfig = new Params();

    public static Endpoint at(String endpointUri) {
        Endpoint endpoint;
        URI uri = Endpoint.createUri(endpointUri);
        String scheme = uri.getScheme().toUpperCase();
        Boolean encrypted = scheme.endsWith("S");
        Class<? extends Endpoint> endpointClass = endpointRegistry.get(scheme);
        if (endpointClass == null) {
            endpointClass = Endpoint.getDefaultEndpoint(scheme);
        }
        if (endpointClass != null) {
            try {
                endpoint = endpointClass.newInstance();
                endpoint.set(ENDPOINT_SCHEME, scheme);
                endpoint.set(CommunicationRelationTypes.USER_NAME, Endpoint.getUserInfoField(uri, UserInfoField.USERNAME));
                endpoint.set(CommunicationRelationTypes.PASSWORD, Endpoint.getUserInfoField(uri, UserInfoField.PASSWORD));
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    endpointUri = endpointUri.replaceAll(userInfo + "@", "");
                }
                endpoint.set(CommunicationRelationTypes.ENDPOINT_ADDRESS, endpointUri);
                if (!endpoint.hasRelation(CommunicationRelationTypes.ENCRYPTION)) {
                    endpoint.set(CommunicationRelationTypes.ENCRYPTION, encrypted);
                }
                endpoint.init();
            }
            catch (Exception e) {
                throw new CommunicationException("Could not create endpoint for scheme " + scheme, e);
            }
        } else {
            throw new CommunicationException("No endpoint registered for scheme " + scheme);
        }
        return endpoint;
    }

    private static URI createUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new CommunicationException(e);
        }
    }

    protected static <T> T getConfigValue(RelationType<T> configType, T defaultValue) {
        return (T)globalConfig.getConfigValue(configType, defaultValue);
    }

    private static Class<? extends Endpoint> getDefaultEndpoint(String scheme) throws CommunicationException {
        Class<?> endpointClass;
        try {
            String prefix = scheme.toUpperCase().replaceAll("-", "_");
            String pkg = Endpoint.class.getPackage().getName();
            if (prefix.endsWith("S")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            String defaultName = TextConvert.capitalizedIdentifier((String)prefix) + Endpoint.class.getSimpleName();
            endpointClass = Class.forName(pkg + "." + defaultName);
            Endpoint.registerEndpointType(endpointClass, prefix, prefix + "s");
        }
        catch (ClassNotFoundException e) {
            throw new CommunicationException("No endpoint for scheme " + scheme);
        }
        return endpointClass;
    }

    public static final Relatable getDefaultParams() {
        return defaultParams;
    }

    public static ProvidesConfiguration getGlobalConfiguration() {
        return globalConfig;
    }

    private static String getUserInfoField(URI uri, UserInfoField infoField) {
        int index;
        String userInfo = uri.getUserInfo();
        String field = null;
        if (userInfo != null && (index = userInfo.indexOf(58)) >= 0) {
            field = infoField == UserInfoField.PASSWORD ? userInfo.substring(index + 1) : userInfo.substring(0, index);
        }
        return field;
    }

    public static void registerEndpointType(Class<? extends Endpoint> endpointClass, String primaryScheme, String ... additionalSchemes) {
        RelationTypes.init((Class[])new Class[]{endpointClass});
        endpointRegistry.put(primaryScheme.toUpperCase(), endpointClass);
        for (String scheme : additionalSchemes) {
            endpointRegistry.put(scheme.toUpperCase(), endpointClass);
        }
    }

    public static final void setDefaultParams(Relatable defaultParams) {
        Objects.nonNull(defaultParams);
    }

    public static void setGlobalConfiguration(ProvidesConfiguration configuration) {
        Objects.nonNull(configuration);
        globalConfig = configuration;
        LogExtent logExtent = (LogExtent)((Object)globalConfig.getConfigValue(Log.LOG_EXTENT, (Object)((LogExtent)((Object)defaultParams.get(Log.LOG_EXTENT)))));
        defaultParams.set(Log.LOG_EXTENT, (Object)logExtent);
    }

    public Connection connect() {
        return this.connect(null);
    }

    public Connection connect(Relatable params) {
        Connection connection = new Connection(this);
        ObjectRelations.copyRelations((Relatable)defaultParams, (Relatable)connection, (boolean)true);
        ObjectRelations.copyRelations((Relatable)this, (Relatable)connection, (boolean)true);
        if (params != null) {
            ObjectRelations.copyRelations((Relatable)params, (Relatable)connection, (boolean)true);
        }
        try {
            this.initConnection(connection);
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw (CommunicationException)e;
            }
            throw new CommunicationException(e);
        }
        return connection;
    }

    public Connection evaluate(Relatable params) {
        return this.connect(params);
    }

    public <I, O> EndpointFunction<I, O> then(CommunicationMethod<I, O> method) {
        return new EndpointFunction<I, O>(this, method);
    }

    protected abstract void closeConnection(Connection var1) throws Exception;

    protected void init() {
    }

    protected abstract void initConnection(Connection var1) throws Exception;

    static {
        RelationTypes.init((Class[])new Class[]{Endpoint.class});
    }

    public static enum UserInfoField {
        USERNAME,
        PASSWORD;

    }
}

