/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.comm.CommunicationChain;
import de.esoco.lib.comm.CommunicationMethod;
import de.esoco.lib.comm.Connection;
import de.esoco.lib.comm.Endpoint;
import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.Function;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;

public class EndpointFunction<I, O>
extends RelatedObject
implements BinaryFunction<I, Relatable, O> {
    private final Endpoint endpoint;
    private final CommunicationMethod<I, O> method;

    public EndpointFunction(Endpoint endpoint, CommunicationMethod<I, O> method) {
        this.endpoint = endpoint;
        this.method = method;
    }

    public O evaluate(I input, Relatable params) {
        try (Connection connection = this.endpoint.connect(params);){
            this.set(Endpoint.ENDPOINT_CONNECTION, connection);
            O o = this.method.evaluate(input, connection);
            return o;
        }
    }

    public O receive() {
        return (O)this.evaluate(null);
    }

    public O send() {
        return (O)this.evaluate(null);
    }

    public O send(I input) {
        return (O)this.evaluate(input);
    }

    public <T> EndpointFunction<I, T> then(Function<? super O, T> other) {
        return new EndpointFunction<I, O>(this.endpoint, new CommunicationChain<I, O, T>(this.method, other));
    }
}

