/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.comm.CommunicationException;
import de.esoco.lib.comm.CommunicationMethod;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Connection;
import de.esoco.lib.comm.Endpoint;
import de.esoco.lib.comm.http.HttpRequestMethod;
import de.esoco.lib.comm.http.HttpStatusCode;
import de.esoco.lib.comm.http.HttpStatusException;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.io.LimitedInputStream;
import de.esoco.lib.io.LimitedOutputStream;
import de.esoco.lib.io.StreamUtil;
import de.esoco.lib.net.NetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpEndpoint
extends Endpoint {
    public static CommunicationMethod<String, String> httpGet() {
        return HttpEndpoint.httpGet(null);
    }

    public static HttpRequest<String, String> httpGet(String targetUrl) {
        return new HttpRequest<String, String>("HttpGet(%s)", targetUrl, HttpRequestMethod.GET, "", (Function<String, String>)Functions.identity(), (Function<String, String>)Functions.identity());
    }

    public static HttpRequest<String, String> httpPost(String targetUrl, String postData) {
        HttpRequest<String, String> postRequest = new HttpRequest<String, String>("HttpPost(%s)", postData, HttpRequestMethod.POST, targetUrl, (Function<String, String>)Functions.identity(), (Function<String, String>)Functions.identity());
        return postRequest;
    }

    public static String url(String host, int port, boolean encrypted) {
        String scheme = encrypted ? "https" : "http";
        String url = port > 0 ? String.format("%s://%s:%d", scheme, host, port) : String.format("%s://%s", scheme, host);
        return url;
    }

    @Override
    protected void closeConnection(Connection connection) {
    }

    @Override
    protected void initConnection(Connection connection) {
    }

    public static class HttpRequest<I, O>
    extends CommunicationMethod<I, O> {
        private final HttpRequestMethod requestMethod;
        private final String baseUrl;
        private final Function<I, String> provideRequestData;
        private final Function<String, O> processResponse;
        private final Map<String, String> requestHeaders = new LinkedHashMap<String, String>();

        public HttpRequest(String methodName, I defaultInput, HttpRequestMethod requestMethod, String baseUrl, Function<I, String> provideRequestData, Function<String, O> processResponse) {
            super(methodName, defaultInput);
            this.requestMethod = requestMethod;
            this.baseUrl = baseUrl;
            this.provideRequestData = provideRequestData;
            this.processResponse = processResponse;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public O doOn(Connection connection, I input) {
            HttpURLConnection urlConnection = this.setupUrlConnection(connection, input);
            try {
                if (this.requestMethod.doesOutput()) {
                    try (LimitedOutputStream outStream = new LimitedOutputStream(urlConnection.getOutputStream(), (Integer)connection.get(CommunicationRelationTypes.MAX_REQUEST_SIZE));){
                        this.writeRequest(connection, outStream, input);
                    }
                }
                try (LimitedInputStream inputStream = new LimitedInputStream(urlConnection.getInputStream(), (Integer)connection.get(CommunicationRelationTypes.MAX_RESPONSE_SIZE));){
                    InputStreamReader inputReader222 = new InputStreamReader((InputStream)inputStream, (Charset)connection.get(CommunicationRelationTypes.RESPONSE_ENCODING));
                    connection.set(CommunicationRelationTypes.HTTP_STATUS_CODE, (Object)HttpStatusCode.valueOf(urlConnection.getResponseCode()));
                    connection.set(CommunicationRelationTypes.HTTP_RESPONSE_HEADERS, urlConnection.getHeaderFields());
                    O o = this.readResponse(connection, inputReader222);
                    return o;
                }
            }
            catch (Exception e) {
                int responseCode;
                try {
                    responseCode = urlConnection.getResponseCode();
                }
                catch (IOException e2) {
                    throw new CommunicationException(e);
                }
                if (responseCode == -1) throw new CommunicationException(e);
                return this.handleHttpError(urlConnection, e, HttpStatusCode.valueOf(responseCode));
            }
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        public final Function<I, String> getRequestDataProvider() {
            return this.provideRequestData;
        }

        public HttpRequestMethod getRequestMethod() {
            return this.requestMethod;
        }

        public final Function<String, O> getResponseProcessor() {
            return this.processResponse;
        }

        protected void applyRequestHeaders(Connection connection, HttpURLConnection urlConnection) {
            urlConnection.setRequestProperty("Accept-Charset", ((Charset)connection.get(CommunicationRelationTypes.REQUEST_ENCODING)).name());
            for (Map.Entry<String, String> entry : this.requestHeaders.entrySet()) {
                urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (connection.hasRelation(CommunicationRelationTypes.HTTP_REQUEST_HEADERS)) {
                for (Map.Entry<String, String> entry : ((Map)connection.get(CommunicationRelationTypes.HTTP_REQUEST_HEADERS)).entrySet()) {
                    String headerName = entry.getKey();
                    List headerValues = (List)((Object)entry.getValue());
                    for (String value : headerValues) {
                        urlConnection.setRequestProperty(headerName, value);
                    }
                }
            }
        }

        @Override
        protected String getMethodDescription(Connection connection, I input) {
            StringBuilder description = new StringBuilder("HTTP ");
            description.append((Object)this.requestMethod).append(' ');
            description.append(this.getTargetUrl(connection, input));
            Map<String, String> headers = this.getRequestHeaders(connection);
            if (this.requestMethod.doesOutput()) {
                description.append("\nData: ");
                description.append(this.getRequestData(connection, input));
            }
            if (!headers.isEmpty()) {
                description.append("\nHeaders: ").append(headers);
            }
            return description.toString();
        }

        protected String getRequestData(Connection connection, I input) {
            return (String)this.provideRequestData.evaluate(input);
        }

        protected Map<String, String> getRequestHeaders(Connection connection) {
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(this.requestHeaders);
            if (connection.hasRelation(CommunicationRelationTypes.HTTP_REQUEST_HEADERS)) {
                for (Map.Entry header : ((Map)connection.get(CommunicationRelationTypes.HTTP_REQUEST_HEADERS)).entrySet()) {
                    String headerName = (String)header.getKey();
                    List headerValues = (List)header.getValue();
                    headers.put(headerName, headerValues.size() == 1 ? (String)headerValues.get(0) : headerValues.toString());
                }
            }
            return headers;
        }

        protected String getTargetUrl(Connection connection, I input) {
            String endpointAddress = (String)connection.getEndpoint().get(CommunicationRelationTypes.ENDPOINT_ADDRESS);
            StringBuilder urlBuilder = new StringBuilder(endpointAddress);
            NetUtil.appendUrlPath(urlBuilder, this.baseUrl);
            if (!this.requestMethod.doesOutput()) {
                String requestData = this.getRequestData(connection, input);
                NetUtil.appendUrlPath(urlBuilder, requestData);
            }
            return urlBuilder.toString();
        }

        protected O handleHttpError(HttpURLConnection urlConnection, Exception httpException, HttpStatusCode statusCode) {
            throw new HttpStatusException(statusCode, httpException);
        }

        protected O processResponse(Connection connection, String rawResponse) {
            return (O)this.processResponse.evaluate((Object)rawResponse);
        }

        protected O readResponse(Connection connection, Reader inputReader) throws IOException {
            String rawResponse = StreamUtil.readAll(inputReader, (int)((Integer)connection.get(CommunicationRelationTypes.BUFFER_SIZE)), Integer.MAX_VALUE);
            return this.processResponse(connection, rawResponse);
        }

        protected HttpURLConnection setupUrlConnection(Connection connection, I input) {
            try {
                String targetUrl = this.getTargetUrl(connection, input);
                HttpURLConnection urlConnection = (HttpURLConnection)new URL(targetUrl).openConnection();
                this.requestMethod.applyTo(urlConnection);
                this.applyRequestHeaders(connection, urlConnection);
                String userName = connection.getUserName();
                if (userName != null) {
                    NetUtil.enableHttpBasicAuth(urlConnection, userName, connection.getPassword());
                }
                return urlConnection;
            }
            catch (Exception e) {
                throw new CommunicationException(e);
            }
        }

        protected void writeRequest(Connection connection, OutputStream outputStream, I input) throws IOException {
            String requestData = this.getRequestData(connection, input);
            if (requestData.length() > 0) {
                Charset encoding = (Charset)connection.get(CommunicationRelationTypes.REQUEST_ENCODING);
                outputStream.write(requestData.getBytes(encoding));
                outputStream.flush();
            }
        }
    }
}

