/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.comm.CommunicationException;
import de.esoco.lib.comm.CommunicationMethod;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Connection;
import de.esoco.lib.comm.Endpoint;
import de.esoco.lib.comm.HttpEndpoint;
import de.esoco.lib.comm.JsonRpcRequestData;
import de.esoco.lib.comm.PipeEndpoint;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.json.Json;
import de.esoco.lib.json.JsonObject;
import de.esoco.lib.json.JsonParser;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public class JsonRpcEndpoint
extends Endpoint {
    public static final RelationType<JsonRpcBatchCall> RPC_BATCH_CALL = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private static final RelationType<Connection> RPC_SERVER_CONNECTION = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[]{RelationTypeModifier.PRIVATE});
    private static final RelationType<CommunicationMethod<String, String>> RPC_SERVER_METHOD = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[]{RelationTypeModifier.PRIVATE});

    public static JsonRpcBatchCall batchCall() {
        return new JsonRpcBatchCall();
    }

    @SafeVarargs
    public static <P, R> JsonRpcBatchMethod<P, R> batchCall(JsonRpcMethod<P, R> method, P ... defaultParams) {
        return new JsonRpcBatchMethod<P, R>(method, Arrays.asList(defaultParams));
    }

    public static JsonRpcMethod<Object, Object> call(String method) {
        return JsonRpcEndpoint.call(method, null, (String json) -> Json.parse((String)json));
    }

    public static <R> JsonRpcMethod<Object, R> call(String method, Class<R> resultType) {
        return JsonRpcEndpoint.call(method, null, resultType);
    }

    public static <P, R> JsonRpcMethod<P, R> call(String method, P defaultParams, Class<R> resultType) {
        return new JsonRpcMethod<P, R>(method, defaultParams, resultType);
    }

    public static <P, R> JsonRpcMethod<P, R> call(String method, P defaultParams, Function<String, R> parseResponse) {
        return new JsonRpcMethod<P, R>(method, defaultParams, parseResponse);
    }

    @Override
    protected void closeConnection(Connection connection) throws Exception {
        ((Connection)connection.get(RPC_SERVER_CONNECTION)).close();
    }

    @Override
    protected void initConnection(Connection connection) throws Exception {
        CommunicationMethod transportMethod;
        Endpoint transportEndpoint;
        URI uri = connection.getUri();
        String targetUrl = uri.getSchemeSpecificPart();
        if (targetUrl.startsWith("http")) {
            URL url = new URL(targetUrl);
            transportEndpoint = Endpoint.at(HttpEndpoint.url(url.getHost(), url.getPort(), url.getProtocol().endsWith("s")));
            transportMethod = HttpEndpoint.httpPost(url.getPath(), null);
        } else if (targetUrl.startsWith("pipe")) {
            transportEndpoint = Endpoint.at(targetUrl);
            transportMethod = PipeEndpoint.textRequest(null);
        } else {
            throw new CommunicationException("Unsupported JSON RPC transport: " + targetUrl);
        }
        Connection transportConnection = transportEndpoint.connect((Relatable)connection);
        connection.set(RPC_SERVER_CONNECTION, transportConnection);
        connection.set((RelationType)RPC_SERVER_METHOD, (Object)transportMethod);
        ((Map)transportConnection.get(CommunicationRelationTypes.HTTP_REQUEST_HEADERS)).put("Content-Type", Collections.singletonList("application/json"));
    }

    public static class JsonRpcBatchCall
    extends JsonRpcBatch<Call<?>, Object> {
        private int firstId;

        public JsonRpcBatchCall() {
            super(JsonRpcBatchCall.class.getSimpleName(), Collections.emptyList());
        }

        @Override
        public Object buildRequest(List<Call<?>> calls, int id) {
            this.firstId = id;
            ArrayList<Object> callRequests = new ArrayList<Object>(calls.size());
            for (Call<?> call : calls) {
                Object request = ((Call)call).request.buildDefaultRequest(id);
                if (request instanceof JsonObject) {
                    callRequests.add(request);
                    ++id;
                    continue;
                }
                if (request instanceof Collection) {
                    Collection batchRequests = (Collection)request;
                    callRequests.addAll(batchRequests);
                    id += batchRequests.size();
                    continue;
                }
                throw new IllegalArgumentException("Unsupported batch request data from " + (Object)((Object)((Call)call).request));
            }
            return callRequests;
        }

        public <R> JsonRpcBatchCall call(JsonRpcRequest<?, R> request, Consumer<? super R> responseHandler) {
            Call<? super R> call = new Call<R>(request, responseHandler);
            ((List)this.getDefaultInput()).add(call);
            return this;
        }

        public boolean isEmpty() {
            return ((List)this.getDefaultInput()).isEmpty();
        }

        public String toString() {
            StringBuilder result = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
            int id = 1;
            for (Call call : (List)this.getDefaultInput()) {
                result.append("\n");
                result.append(call.request.buildDefaultRequest(id++));
            }
            return result.toString();
        }

        @Override
        protected Object parseMethodResponse(JsonObject response, List<Call<?>> calls) {
            int id = response.getInt("id", 0) - this.firstId;
            if (id >= 0 && id < calls.size()) {
                Call<?> call = calls.get(id);
                return call.processResponse(response);
            }
            throw new CommunicationException("No method to parse response ID" + id);
        }
    }

    public static class JsonRpcBatchMethod<P, R>
    extends JsonRpcBatch<P, R> {
        private final JsonRpcMethod<P, ? extends R> rpcMethod;

        public JsonRpcBatchMethod(JsonRpcMethod<P, R> rpcMethod, Collection<P> defaultInputs) {
            super(JsonRpcBatchMethod.class.getSimpleName(), defaultInputs);
            this.rpcMethod = rpcMethod;
        }

        public void add(P callParam) {
            ((List)this.getDefaultInput()).add(callParam);
        }

        public Collection<JsonObject> buildRequest(List<P> inputs, int id) {
            ArrayList<JsonObject> methodRequests = new ArrayList<JsonObject>(inputs.size());
            for (P params : inputs) {
                methodRequests.add(this.rpcMethod.buildRequest(params, id++));
            }
            return methodRequests;
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + this.getDefaultInput();
        }

        @Override
        protected R parseMethodResponse(JsonObject response, List<P> input) {
            return this.rpcMethod.parseResponse(response);
        }
    }

    public static class JsonRpcMethod<P, R>
    extends JsonRpcRequest<P, R> {
        private final String method;
        private final Function<String, R> parseResponse;
        private final Function<? super P, ?> convertInput;

        public JsonRpcMethod(String method, P defaultParams, Class<R> responseType) {
            this(method, defaultParams, (Function<P, ?>)Functions.identity(), (Function<String, R>)JsonParser.parseJson(responseType));
        }

        public JsonRpcMethod(String method, P defaultParams, Function<String, R> parseResponse) {
            this(method, defaultParams, (Function<P, ?>)Functions.identity(), parseResponse);
        }

        public JsonRpcMethod(String method, P defaultParams, Function<? super P, ?> convertInput, Function<String, R> parseResponse) {
            super(method, defaultParams);
            this.method = method;
            this.parseResponse = parseResponse;
            this.convertInput = convertInput;
        }

        public JsonObject buildRequest(P input, int id) {
            return new JsonRpcRequestData(id, this.method).withParams(this.getRequestParams(input));
        }

        public Function<? super P, ?> getInputConversion() {
            return this.convertInput;
        }

        protected Object getRequestParams(P input) {
            return this.convertInput.apply(input);
        }

        @Override
        protected R parseResult(String jsonResult) {
            return this.parseResponse.apply(jsonResult);
        }
    }

    static class Call<R> {
        private final JsonRpcRequest<?, R> request;
        private final Consumer<? super R> responseHandler;

        Call(JsonRpcRequest<?, R> request, Consumer<? super R> responseHandler) {
            this.request = request;
            this.responseHandler = responseHandler;
        }

        public R processResponse(JsonObject response) {
            R result = this.request.parseResponse(response);
            if (this.responseHandler != null) {
                this.responseHandler.accept(result);
            }
            return result;
        }

        public String toString() {
            return String.format("Call(%s)", new Object[]{this.request});
        }
    }

    public static abstract class JsonRpcRequest<P, R>
    extends CommunicationMethod<P, R> {
        public JsonRpcRequest(String name, P defaultParams) {
            super(name, defaultParams);
        }

        public Object buildDefaultRequest(int id) {
            return this.buildRequest(this.getDefaultInput(), id);
        }

        public abstract Object buildRequest(P var1, int var2);

        @Override
        public R doOn(Connection connection, P input) {
            Connection transportConnection = (Connection)connection.get(RPC_SERVER_CONNECTION);
            CommunicationMethod transportMethod = (CommunicationMethod)((Object)connection.get(RPC_SERVER_METHOD));
            Object request = this.buildRequest(input, 1);
            String rawResponse = (String)transportMethod.evaluate(Json.toCompactJson((Object)request), transportConnection);
            return this.parseRawResponse(rawResponse, input);
        }

        protected R parseRawResponse(String rawResponse, P input) {
            JsonObject response = Json.parseObject((String)rawResponse, (int)1);
            return this.parseResponse(response);
        }

        protected R parseResponse(JsonObject response) {
            response.getString("error").ifExists(err -> {
                JsonObject error = Json.parseObject((String)err);
                throw new CommunicationException(String.format("JSON RPC Error %s: %s", error.getString("code"), error.getString("message")));
            });
            return this.parseResult((String)response.getString("result").orFail());
        }

        protected abstract R parseResult(String var1);
    }

    public static abstract class JsonRpcBatch<P, R>
    extends JsonRpcRequest<List<P>, List<R>> {
        public JsonRpcBatch(String name, Collection<P> defaultParams) {
            super(name, new ArrayList<P>(defaultParams));
        }

        public void reset() {
            ((List)this.getDefaultInput()).clear();
        }

        public int size() {
            return ((List)this.getDefaultInput()).size();
        }

        protected abstract R parseMethodResponse(JsonObject var1, List<P> var2);

        @Override
        protected List<R> parseRawResponse(String rawResponse, List<P> inputs) {
            return Json.parseArray((String)rawResponse, (int)1).stream().map(o -> Json.parseObject((String)o.toString(), (int)1)).sorted((j1, j2) -> j1.getInt("id", 0) - j2.getInt("id", 0)).map(response -> this.parseMethodResponse((JsonObject)response, inputs)).collect(Collectors.toList());
        }

        @Override
        protected List<R> parseResult(String rawResponse) {
            return null;
        }
    }
}

