/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.collection.ByteArray;
import de.esoco.lib.comm.CommunicationMethod;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Connection;
import de.esoco.lib.comm.Endpoint;
import de.esoco.lib.io.LimitedOutputStream;
import de.esoco.lib.io.RandomAccessFileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.function.Function;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public class PipeEndpoint
extends Endpoint {
    public static final RelationType<RandomAccessFile> PIPE_FILE = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);

    public static PipeRequest<String, String> textRequest(String defaultRequest) {
        return new PipeRequest<String, String>("PipeRequest(%s)", defaultRequest, s -> s.getBytes(), d -> new String((byte[])d));
    }

    @Override
    protected void closeConnection(Connection connection) throws Exception {
        RandomAccessFile pipeFile = (RandomAccessFile)connection.get(PIPE_FILE);
        if (pipeFile != null) {
            pipeFile.close();
            connection.set(PIPE_FILE, null);
        }
    }

    @Override
    protected void initConnection(Connection connection) throws Exception {
        String pipeName = connection.getUri().getSchemeSpecificPart();
        RandomAccessFile pipeFile = new RandomAccessFile(pipeName, "rw");
        connection.set(PIPE_FILE, pipeFile);
    }

    public static class PipeRequest<I, O>
    extends CommunicationMethod<I, O> {
        private final Function<I, byte[]> convertInput;
        private final Function<byte[], O> processResponse;

        public PipeRequest(String requestName, I defaultInput, Function<I, byte[]> convertInput, Function<byte[], O> processResponse) {
            super(requestName, defaultInput);
            this.convertInput = convertInput;
            this.processResponse = processResponse;
        }

        @Override
        public O doOn(Connection connection, I input) throws IOException {
            int b;
            RandomAccessFile pipeFile = (RandomAccessFile)connection.get(PIPE_FILE);
            try (LimitedOutputStream output = new LimitedOutputStream(new RandomAccessFileOutputStream(pipeFile), (Integer)connection.get(CommunicationRelationTypes.MAX_REQUEST_SIZE));){
                output.write(this.convertInput(input));
            }
            ByteArray rawResponse = new ByteArray((Integer)connection.get(CommunicationRelationTypes.BUFFER_SIZE));
            while ((b = pipeFile.read()) != -1 && pipeFile.length() > 0L) {
                rawResponse.add((byte)b);
            }
            return this.processResponse(rawResponse.toByteArray());
        }

        protected byte[] convertInput(I input) {
            return this.convertInput.apply(input);
        }

        protected O processResponse(byte[] rawResponse) {
            return this.processResponse.apply(rawResponse);
        }
    }
}

