/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.comm.CommunicationException;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.io.LimitedInputStream;
import de.esoco.lib.io.LimitedOutputStream;
import de.esoco.lib.logging.Log;
import de.esoco.lib.logging.LogLevel;
import de.esoco.lib.manage.Releasable;
import de.esoco.lib.manage.RunCheck;
import de.esoco.lib.manage.Stoppable;
import de.esoco.lib.security.Security;
import de.esoco.lib.security.SecurityRelationTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ServerSocketFactory;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationBuilder;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.type.MetaTypes;
import org.obrel.type.StandardTypes;

public class Server
extends RelatedObject
implements RelationBuilder<Server>,
Runnable,
RunCheck,
Stoppable {
    public static final RelationType<RequestHandlerFactory> REQUEST_HANDLER_FACTORY = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private final Lock serverLock = new ReentrantLock();
    private ServerSocket serverSocket;
    private boolean running;

    public Server(RequestHandlerFactory requestHandlerFactory) {
        this.set(REQUEST_HANDLER_FACTORY, requestHandlerFactory);
        this.init(CommunicationRelationTypes.REQUEST_HISTORY);
    }

    @Override
    public final boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        ObjectRelations.require((Relatable)this, (RelationType[])new RelationType[]{StandardTypes.PORT});
        if (this.running) {
            throw new IllegalStateException(this.getServerName() + " already started");
        }
        Log.infof("%s started", this.getServerName());
        try {
            this.runServerLoop();
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    public void stop() {
        if (this.running) {
            this.running = false;
            Log.infof("%s stopped", this.getServerName());
        }
    }

    protected Relatable createRequestContext() {
        RelatedObject requestConfig = new RelatedObject();
        ObjectRelations.copyRelations((Relatable)this, (Relatable)requestConfig, (boolean)true);
        requestConfig.set(MetaTypes.IMMUTABLE);
        return requestConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ServerSocket createServerSocket(int port) throws IOException {
        ServerSocketFactory serverSocketFactory;
        if (this.hasFlag(CommunicationRelationTypes.ENCRYPTION)) {
            KeyStore certificate = (KeyStore)this.get(SecurityRelationTypes.CERTIFICATE);
            if (certificate == null) throw new IllegalStateException(SecurityRelationTypes.CERTIFICATE.getSimpleName() + " parameter missing to enable SSL");
            serverSocketFactory = Security.getSslContext(certificate, (String)this.getOption(SecurityRelationTypes.KEY_PASSWORD).orUse((Object)"")).getServerSocketFactory();
            return serverSocketFactory.createServerSocket(port);
        } else {
            serverSocketFactory = ServerSocketFactory.getDefault();
        }
        return serverSocketFactory.createServerSocket(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClientRequest(Socket clientSocket, Relatable context) {
        RequestHandler requestHandler = ((RequestHandlerFactory)this.get(REQUEST_HANDLER_FACTORY)).getRequestHandler(context);
        requestHandler.init(StandardTypes.TIMER);
        try {
            InputStream clientIn = clientSocket.getInputStream();
            OutputStream clientOut = clientSocket.getOutputStream();
            InetAddress clientAddress = clientSocket.getInetAddress();
            Log.infof("%s: handling request from %s", this.getServerName(), clientAddress.getHostAddress());
            requestHandler.set(StandardTypes.IP_ADDRESS, clientAddress);
            LimitedInputStream input = new LimitedInputStream(clientIn, (Integer)this.get(CommunicationRelationTypes.MAX_REQUEST_SIZE));
            LimitedOutputStream output = new LimitedOutputStream(clientOut, (Integer)this.get(CommunicationRelationTypes.MAX_RESPONSE_SIZE));
            String request = requestHandler.handleRequest(input, output);
            request = request.replaceAll("(\r\n|\r|\n)", "\u00b6");
            if (Log.isLevelEnabled(LogLevel.DEBUG)) {
                Log.debugf("Request: %s", request);
            }
            this.serverLock.lock();
            try {
                this.set(CommunicationRelationTypes.LAST_REQUEST, request);
                this.set(CommunicationRelationTypes.REQUEST_HANDLING_TIME, ((Long)requestHandler.get(StandardTypes.TIMER)).intValue());
                if (!this.running) {
                    this.serverSocket.close();
                }
            }
            finally {
                this.serverLock.unlock();
            }
        }
        catch (Exception e) {
            Log.error("Client request handling failed", e);
        }
        finally {
            if (requestHandler instanceof Releasable) {
                ((Releasable)((Object)requestHandler)).release();
            }
            try {
                clientSocket.close();
            }
            catch (IOException e) {
                Log.error("Socket close failed", e);
            }
        }
    }

    protected void runServerLoop() throws IOException {
        Relatable requestContext = this.createRequestContext();
        int maxConnections = (Integer)this.getOption(CommunicationRelationTypes.MAX_CONNECTIONS).orUse((Object)Math.max(4, ForkJoinPool.commonPool().getParallelism()));
        ArrayDeque<CompletableFuture<Void>> requestHandlers = new ArrayDeque<CompletableFuture<Void>>(maxConnections);
        this.serverSocket = this.createServerSocket((Integer)this.get(StandardTypes.PORT));
        this.running = true;
        while (this.running) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                Iterator handlers = requestHandlers.iterator();
                while (handlers.hasNext()) {
                    if (!((CompletableFuture)handlers.next()).isDone()) continue;
                    handlers.remove();
                }
                if (requestHandlers.size() < maxConnections) {
                    CompletableFuture<Void> requestHandler = CompletableFuture.runAsync(() -> this.handleClientRequest(clientSocket, requestContext));
                    requestHandlers.add(requestHandler);
                    continue;
                }
                Log.warn("Maximum connections reached, rejecting connection from " + clientSocket.getInetAddress());
                try {
                    clientSocket.close();
                }
                catch (IOException e) {
                    Log.error("Closing rejected connection failed, continuing");
                }
            }
            catch (SocketException e) {
                if (!this.running) continue;
                throw e;
            }
        }
    }

    private String getServerName() {
        String name = (String)this.get(StandardTypes.NAME);
        if (name == null) {
            name = this.getClass().getSimpleName();
        }
        return name;
    }

    static {
        RelationTypes.init((Class[])new Class[]{Server.class});
    }

    @FunctionalInterface
    public static interface RequestHandlerFactory {
        public RequestHandler getRequestHandler(Relatable var1);
    }

    public static interface RequestHandler
    extends Relatable {
        public String handleRequest(InputStream var1, OutputStream var2) throws Exception;
    }
}

