/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Connection;
import de.esoco.lib.comm.SocketEndpoint;
import de.esoco.lib.comm.smtp.Email;
import de.esoco.lib.comm.smtp.SmtpProtocolHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Objects;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public class SmtpEndpoint
extends SocketEndpoint {
    private static final RelationType<DataInputStream> SMTP_INPUT_STREAM = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[]{RelationTypeModifier.PRIVATE});
    private static final RelationType<DataOutputStream> SMTP_OUTPUT_STREAM = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[]{RelationTypeModifier.PRIVATE});

    public static SmtpRequest sendMail() {
        return new SmtpRequest(null);
    }

    public static SmtpRequest sendMail(Email defaultEmail) {
        return new SmtpRequest(defaultEmail);
    }

    @Override
    protected void initConnection(Connection connection) throws IOException {
        super.initConnection(connection);
        Socket socket = this.getSocket(connection);
        DataOutputStream dataOut = new DataOutputStream(socket.getOutputStream());
        DataInputStream dataIn = new DataInputStream(socket.getInputStream());
        connection.set(SMTP_OUTPUT_STREAM, dataOut);
        connection.set(SMTP_INPUT_STREAM, dataIn);
    }

    public static class SmtpRequest
    extends SocketEndpoint.SocketRequest<Email, Void> {
        protected SmtpRequest(Email defaultEmail) {
            super(SmtpRequest.class.getSimpleName(), defaultEmail);
        }

        @Override
        protected Void sendRequest(Connection connection, OutputStream output, InputStream input, Email email) throws Exception {
            SmtpProtocolHandler smtpHandler = new SmtpProtocolHandler("localhost", output, input);
            String from = (String)email.get(Email.SENDER_ADDRESS);
            String to = (String)email.get(Email.RECIPIENT_ADDRESS);
            if (from == null || to == null) {
                String query = connection.getUri().getQuery();
                String[] queryElements = query.split("&");
                HashMap<String, String> params = new HashMap<String, String>();
                for (String element : queryElements) {
                    String[] param = element.split("=");
                    if (param.length != 2) continue;
                    params.put(param[0].toLowerCase(), param[1]);
                }
                from = from == null ? (String)params.get("from") : from;
                to = to == null ? (String)params.get("to") : to;
                Objects.requireNonNull(from, "Missing sender address");
                Objects.requireNonNull(to, "Missing recipient address");
                email.set(Email.SENDER_ADDRESS, from);
                email.set(Email.RECIPIENT_ADDRESS, to);
            }
            smtpHandler.connect((String)connection.get(CommunicationRelationTypes.USER_NAME), (String)connection.get(CommunicationRelationTypes.PASSWORD));
            smtpHandler.send(email);
            smtpHandler.disconnect();
            return null;
        }
    }
}

