/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm;

import de.esoco.lib.comm.CommunicationMethod;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Connection;
import de.esoco.lib.comm.Endpoint;
import de.esoco.lib.expression.Function;
import de.esoco.lib.io.StreamUtil;
import de.esoco.lib.net.NetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.Socket;
import java.net.URI;

public class SocketEndpoint
extends Endpoint {
    public static final String SOCKET_URL_SCHEME = "socket";
    public static final String ENCRYPTED_SOCKET_URL_SCHEME = "sockets";

    public static BinaryRequest binaryRequest(byte[] defaultCommand, Function<InputStream, Integer> getResponseSize) {
        return new BinaryRequest("BinaryRequest(%s)", defaultCommand, getResponseSize);
    }

    public static TextRequest textRequest(String defaultCommand, Function<Reader, Integer> getResponseSize) {
        return new TextRequest("TextRequest(%s)", defaultCommand, getResponseSize);
    }

    public static String url(String host, int port, boolean encrypted) {
        String scheme = encrypted ? ENCRYPTED_SOCKET_URL_SCHEME : SOCKET_URL_SCHEME;
        String url = port > 0 ? String.format("%s://%s:%d", scheme, host, port) : String.format("%s://%s", scheme, host);
        return url;
    }

    @Override
    protected void closeConnection(Connection connection) throws IOException {
        Socket socket = (Socket)connection.get(CommunicationRelationTypes.ENDPOINT_SOCKET);
        if (socket != null) {
            if (!socket.isClosed()) {
                socket.close();
            }
            connection.set(CommunicationRelationTypes.ENDPOINT_SOCKET, null);
        }
    }

    protected Socket getSocket(Connection connection) {
        return (Socket)connection.get(CommunicationRelationTypes.ENDPOINT_SOCKET);
    }

    @Override
    protected void initConnection(Connection connection) throws IOException {
        NetUtil.SocketType socketType;
        URI uri = connection.getUri();
        NetUtil.SocketType socketType2 = socketType = this.hasFlag(CommunicationRelationTypes.ENCRYPTION) ? NetUtil.SocketType.SSL : NetUtil.SocketType.PLAIN;
        if (socketType == NetUtil.SocketType.SSL && connection.hasFlag(CommunicationRelationTypes.TRUST_SELF_SIGNED_CERTIFICATES)) {
            socketType = NetUtil.SocketType.SELF_SIGNED_SSL;
        }
        Socket socket = NetUtil.createSocket(uri.getHost(), uri.getPort(), socketType);
        socket.setSoTimeout((Integer)connection.get(CommunicationRelationTypes.CONNECTION_TIMEOUT));
        connection.set(CommunicationRelationTypes.ENDPOINT_SOCKET, socket);
        if (socketType != NetUtil.SocketType.PLAIN && !this.hasRelation(CommunicationRelationTypes.ENCRYPTION)) {
            connection.set(CommunicationRelationTypes.ENCRYPTION);
        }
    }

    public static class BinaryRequest
    extends SocketRequest<byte[], byte[]> {
        private final Function<InputStream, Integer> getResponseSize;

        protected BinaryRequest(String methodName, byte[] defaultRequest, Function<InputStream, Integer> getResponseSize) {
            super(methodName, defaultRequest);
            this.getResponseSize = getResponseSize;
        }

        @Override
        protected byte[] readResponse(Connection connection, InputStream inputStream) throws Exception {
            byte[] result = null;
            if (this.getResponseSize != null) {
                int responseSize = (Integer)this.getResponseSize.evaluate((Object)inputStream);
                result = StreamUtil.readAll(inputStream, 1024, responseSize);
            }
            return result;
        }

        @Override
        protected void writeRequest(Connection connection, OutputStream outputStream, byte[] request) throws Exception {
            outputStream.write(request);
        }
    }

    public static class TextRequest
    extends SocketRequest<String, String> {
        private final Function<Reader, Integer> getResponseSize;

        public TextRequest(String methodName, String defaultRequest, Function<Reader, Integer> getResponseSize) {
            super(methodName, defaultRequest);
            this.getResponseSize = getResponseSize;
        }

        @Override
        protected String readResponse(Connection connection, InputStream inputStream) throws Exception {
            String result = null;
            if (this.getResponseSize != null) {
                Reader reader = (Reader)connection.get(CommunicationRelationTypes.SOCKET_READER);
                if (reader == null) {
                    reader = new InputStreamReader(inputStream);
                    connection.set(CommunicationRelationTypes.SOCKET_READER, reader);
                }
                int responseSize = (Integer)this.getResponseSize.evaluate((Object)reader);
                result = StreamUtil.readAll(reader, 1024, responseSize);
            }
            return result;
        }

        @Override
        protected void writeRequest(Connection connection, OutputStream outputStream, String request) throws Exception {
            PrintWriter writer = (PrintWriter)connection.get(CommunicationRelationTypes.SOCKET_WRITER);
            if (writer == null) {
                writer = new PrintWriter(outputStream);
                connection.set(CommunicationRelationTypes.SOCKET_WRITER, writer);
            }
            writer.println(request);
            writer.flush();
        }
    }

    public static abstract class SocketRequest<I, O>
    extends CommunicationMethod<I, O> {
        protected SocketRequest(String methodName, I defaultRequest) {
            super(methodName, defaultRequest);
        }

        @Override
        public O doOn(Connection connection, I request) throws Exception {
            Socket socket = (Socket)connection.get(CommunicationRelationTypes.ENDPOINT_SOCKET);
            OutputStream output = socket.getOutputStream();
            InputStream input = socket.getInputStream();
            connection.set(CommunicationRelationTypes.SOCKET_OUTPUT_STREAM, output);
            connection.set(CommunicationRelationTypes.SOCKET_INPUT_STREAM, input);
            return this.sendRequest(connection, output, input, request);
        }

        protected O readResponse(Connection connection, InputStream inputStream) throws Exception {
            return null;
        }

        protected O sendRequest(Connection connection, OutputStream output, InputStream input, I data) throws Exception {
            this.writeRequest(connection, output, data);
            output.flush();
            return this.readResponse(connection, input);
        }

        protected void writeRequest(Connection connection, OutputStream outputStream, I request) throws Exception {
        }
    }
}

