/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm.http;

import de.esoco.lib.text.TextConvert;
import java.util.Collection;
import org.obrel.core.Annotations;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.type.CollectorType;

@Annotations.RelationTypeNamespace(value="de.esoco.lib.comm.http")
public class HttpHeaderTypes {
    public static final String HTTP_HEADER_TYPES_NAMESPACE = "de.esoco.lib.comm.http";
    public static final RelationType<HttpHeaderField> HTTP_HEADER_FIELD = RelationTypes.newEnumType((String)"de.esoco.lib.comm.http.HTTP_HEADER_FIELD", HttpHeaderField.class, (RelationTypeModifier[])new RelationTypeModifier[]{RelationTypeModifier.FINAL});
    public static final RelationType<String> ACCEPT = RelationTypes.newStringType((RelationTypeModifier[])new RelationTypeModifier[0]).annotate(HTTP_HEADER_FIELD, (Object)HttpHeaderField.ACCEPT);
    public static final RelationType<String> ACCEPT_CHARSET = RelationTypes.newStringType((RelationTypeModifier[])new RelationTypeModifier[0]).annotate(HTTP_HEADER_FIELD, (Object)HttpHeaderField.ACCEPT_CHARSET);
    public static final RelationType<String> AUTHORIZATION = RelationTypes.newStringType((RelationTypeModifier[])new RelationTypeModifier[0]).annotate(HTTP_HEADER_FIELD, (Object)HttpHeaderField.AUTHORIZATION);
    public static final RelationType<Integer> CONTENT_LENGTH = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]).annotate(HTTP_HEADER_FIELD, (Object)HttpHeaderField.CONTENT_LENGTH);
    public static final RelationType<String> CONTENT_TYPE = RelationTypes.newStringType((RelationTypeModifier[])new RelationTypeModifier[0]).annotate(HTTP_HEADER_FIELD, (Object)HttpHeaderField.CONTENT_TYPE);
    public static final RelationType<String> COOKIE = RelationTypes.newStringType((RelationTypeModifier[])new RelationTypeModifier[0]).annotate(HTTP_HEADER_FIELD, (Object)HttpHeaderField.COOKIE);
    public static final RelationType<String> HOST = RelationTypes.newStringType((RelationTypeModifier[])new RelationTypeModifier[0]).annotate(HTTP_HEADER_FIELD, (Object)HttpHeaderField.HOST);
    public static final RelationType<String> USER_AGENT = RelationTypes.newStringType((RelationTypeModifier[])new RelationTypeModifier[0]).annotate(HTTP_HEADER_FIELD, (Object)HttpHeaderField.USER_AGENT);
    public static final RelationType<Collection<RelationType<?>>> HTTP_HEADER_TYPES = CollectorType.newDistinctCollector(RelationType.class, (r, o) -> r.getType().getName().startsWith(HTTP_HEADER_TYPES_NAMESPACE) ? r.getType() : null, (RelationTypeModifier[])new RelationTypeModifier[]{RelationTypeModifier.READONLY});

    public static RelationType<?> get(String headerName) {
        headerName = headerName.replaceAll("-", "_").toUpperCase();
        return RelationType.valueOf((String)("de.esoco.lib.comm.http." + headerName));
    }

    static {
        RelationTypes.init((Class[])new Class[]{HttpHeaderTypes.class});
    }

    public static enum HttpHeaderField {
        ACCEPT,
        ACCEPT_CHARSET,
        AUTHORIZATION,
        CONNECTION,
        CONTENT_LENGTH,
        CONTENT_TYPE,
        COOKIE,
        HOST,
        USER_AGENT,
        WWW_AUTHENTICATE("WWW-Authenticate");

        private final String fieldName;

        private HttpHeaderField() {
            this.fieldName = TextConvert.capitalize((String)this.name(), (String)"-");
        }

        private HttpHeaderField(String fieldName) {
            this.fieldName = fieldName;
        }

        public final String getFieldName() {
            return this.fieldName;
        }
    }
}

